/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.util;

import com.cryptomathic.util.ByteArray;
import java.math.BigInteger;
import java.util.Random;
import java.util.Vector;

public class BitString {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    public static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    protected long[] value;
    protected int bitLength;
    protected int wordLength;
    private static final int[] T = new int[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};

    private static final int unitIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static final long bitMask(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    private final void checkBit(int bit) {
        if (bit < 0) {
            throw new IndexOutOfBoundsException("bit < 0: " + bit);
        }
        if (bit >= this.bitLength) {
            throw new IndexOutOfBoundsException("bit > " + this.bitLength + ": " + bit);
        }
    }

    private final void ensureSpace(int nbits) {
        int thisWordLength = BitString.unitIndex(nbits - 1) + 1;
        if (thisWordLength > this.wordLength) {
            long[] newValue = new long[thisWordLength];
            System.arraycopy(this.value, 0, newValue, 0, this.wordLength);
            this.wordLength = thisWordLength;
            this.value = newValue;
        }
    }

    public BitString(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.wordLength = BitString.unitIndex(nbits - 1) + 1;
        this.value = new long[this.wordLength];
        this.bitLength = nbits;
    }

    public BitString(BitString bitString) {
        this.value = new long[bitString.wordLength];
        System.arraycopy(bitString.value, 0, this.value, 0, bitString.wordLength);
        this.bitLength = bitString.bitLength;
        this.wordLength = bitString.wordLength;
    }

    public BitString(BitString bitString, int bitlength) {
        this(bitlength);
        if (bitString.bitLength > bitlength) {
            throw new IllegalArgumentException("bitlength too small");
        }
        System.arraycopy(bitString.value, 0, this.value, 0, bitString.wordLength);
    }

    public BitString(int bitlength, byte[] bytes) {
        this(bitlength);
        if (bytes.length > (bitlength + 7) / 8) {
            throw new IllegalArgumentException("Bytestring too long");
        }
        int i = bytes.length - 1;
        int j = 0;
        int shiftby = 0;
        while (i >= 0) {
            int n = j / 8;
            this.value[n] = this.value[n] | (long)(bytes[i] & 0xFF) << shiftby;
            --i;
            ++j;
            shiftby = (shiftby + 8) % 64;
        }
    }

    public BitString(int bitlength, int low) {
        this(bitlength);
        this.value[0] = low;
    }

    public BitString(String string) {
        this(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '1') {
                this.set(i);
                continue;
            }
            if (string.charAt(i) == '0') continue;
            throw new IllegalArgumentException("string contained '" + string.charAt(i) + "'");
        }
    }

    public int bitLength() {
        return this.bitLength;
    }

    public int wordLength() {
        return this.wordLength;
    }

    public long getWord(int i) {
        return this.value[i];
    }

    public void truncate(int n) {
        this.bitLength = n;
        this.wordLength = BitString.unitIndex(n - 1) + 1;
    }

    public void clear(int bit) {
        this.checkBit(bit);
        int n = BitString.unitIndex(bit);
        this.value[n] = this.value[n] & (BitString.bitMask(bit) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clearTopBits(int n) {
        int large = n / 64;
        int small = large == 0 ? n : n % (large * 64);
        long mask = (1L << 64 - small) - 1L << (this.bitLength - n & 0x3F);
        int n2 = BitString.unitIndex(this.bitLength - n);
        this.value[n2] = this.value[n2] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        for (int i = this.wordLength - 1; i >= this.wordLength - large; --i) {
            this.value[i] = 0L;
        }
    }

    public void set(int bit) {
        this.checkBit(bit);
        int n = BitString.unitIndex(bit);
        this.value[n] = this.value[n] | BitString.bitMask(bit);
    }

    public void set(int bit, boolean v) {
        this.checkBit(bit);
        if (v) {
            int n = BitString.unitIndex(bit);
            this.value[n] = this.value[n] | BitString.bitMask(bit);
        } else {
            int n = BitString.unitIndex(bit);
            this.value[n] = this.value[n] & (BitString.bitMask(bit) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean get(int bit) {
        this.checkBit(bit);
        return (this.value[BitString.unitIndex(bit)] & BitString.bitMask(bit)) != 0L;
    }

    public void assign(BitString bitString) {
        this.ensureSpace(bitString.bitLength);
        System.arraycopy(bitString.value, 0, this.value, 0, bitString.value.length);
        for (int i = bitString.value.length; i < this.value.length; ++i) {
            this.value[i] = 0L;
        }
    }

    public void and(BitString bitString) {
        this.ensureSpace(bitString.bitLength);
        for (int i = 0; i < bitString.value.length; ++i) {
            int n = i;
            this.value[n] = this.value[n] & bitString.value[i];
        }
    }

    public void or(BitString bitString) {
        this.ensureSpace(bitString.bitLength);
        for (int i = 0; i < bitString.wordLength; ++i) {
            int n = i;
            this.value[n] = this.value[n] | bitString.value[i];
        }
    }

    public void xor(BitString bitString) {
        this.ensureSpace(bitString.bitLength);
        for (int i = 0; i < bitString.wordLength; ++i) {
            int n = i;
            this.value[n] = this.value[n] ^ bitString.value[i];
        }
    }

    public void xor(BitString bitString, int word) {
        this.ensureSpace(bitString.bitLength + word * 64);
        for (int i = 0; i < bitString.wordLength; ++i) {
            int n = word + i;
            this.value[n] = this.value[n] ^ bitString.value[i];
        }
    }

    public BitString domultiply(BitString a, BitString[] Bu) {
        BitString c = new BitString(a.bitLength + this.bitLength - 1);
        for (int k = 15; k >= 0; --k) {
            for (int j = 0; j < this.wordLength; ++j) {
                int u = (int)(a.value[j] >>> 4 * k) & 0xF;
                if (u == 0) continue;
                c.xor(Bu[u], j);
            }
            if (k == 0) continue;
            c.shl(4);
        }
        return c;
    }

    public void shl(int n) {
        int i;
        if (n < 0) {
            this.shr(-n);
        }
        int large = n / 64;
        int small = n & 0x3F;
        if (large > 0) {
            System.arraycopy(this.value, 0, this.value, large, this.wordLength - large);
            for (i = 0; i < large; ++i) {
                this.value[i] = 0L;
            }
        }
        if (small > 0) {
            for (i = this.wordLength - 1; i > large; --i) {
                this.value[i] = this.value[i] << small | this.value[i - 1] >>> 64 - small;
            }
            this.value[large] = this.value[large] << small;
        }
    }

    public void shr(int n) {
        int i;
        if (n < 0) {
            this.shl(-n);
        }
        int large = n / 64;
        int small = n & 0x3F;
        if (large > 0) {
            System.arraycopy(this.value, large, this.value, 0, this.wordLength - large);
            for (i = this.wordLength - large; i < this.wordLength; ++i) {
                this.value[i] = 0L;
            }
        }
        if (small > 0) {
            for (i = 0; i < this.wordLength - large - 1; ++i) {
                this.value[i] = this.value[i] >>> small | this.value[i + 1] << 64 - small;
            }
            this.value[this.wordLength - large - 1] = this.value[this.wordLength - large - 1] >>> small;
        }
    }

    public boolean equals(BitString bitString) {
        if (bitString.bitLength != this.bitLength) {
            return false;
        }
        for (int i = 0; i < this.wordLength; ++i) {
            if (this.value[i] == bitString.value[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        for (int i = 0; i < this.wordLength; ++i) {
            if (this.value[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public String toString_bits() {
        String res = new String();
        for (int i = 0; i < this.bitLength; ++i) {
            res = this.get(i) ? res + '1' : res + '0';
        }
        return res;
    }

    public String toString() {
        return ByteArray.toString(this.toByteArray());
    }

    public byte[] toByteArray() {
        byte[] res = new byte[(this.bitLength + 7) / 8];
        int i = (this.bitLength + 7) / 8 - 1;
        int j = 0;
        int shiftby = 0;
        while (i >= 0) {
            res[i] = (byte)(this.value[j / 8] >> shiftby & 0xFFL);
            --i;
            ++j;
            shiftby = (shiftby + 8) % 64;
        }
        return res;
    }

    public Object clone() {
        return new BitString(this);
    }

    public static BitString and(BitString b1, BitString b2) {
        BitString res = new BitString(b1);
        res.and(b2);
        return res;
    }

    public static BitString or(BitString b1, BitString b2) {
        BitString res = new BitString(b1);
        res.or(b2);
        return res;
    }

    public static BitString xor(BitString b1, BitString b2) {
        BitString res = new BitString(b1);
        res.xor(b2);
        return res;
    }

    public boolean isZeroOrOne() {
        if (this.value[0] != 0L && this.value[0] != 1L) {
            return false;
        }
        for (int i = 1; i < this.wordLength; ++i) {
            if (this.value[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int topBit() {
        int topWordIndex;
        for (topWordIndex = this.wordLength - 1; this.value[topWordIndex] == 0L && topWordIndex > 0; --topWordIndex) {
        }
        long topWord = this.value[topWordIndex];
        int topBitIndex = -1;
        while (topWord != 0L) {
            topWord >>>= 1;
            ++topBitIndex;
        }
        return topWordIndex * 64 + topBitIndex;
    }

    public int[] bits() {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < this.bitLength; ++i) {
            if (!this.get(i)) continue;
            v.addElement(new Integer(i));
        }
        int[] bits = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            bits[i] = (Integer)v.elementAt(i);
        }
        return bits;
    }

    public static BitString RandomBitString(int length, Random rnd) {
        BitString res = new BitString(length);
        for (int i = 0; i < res.wordLength - 1; ++i) {
            res.value[i] = rnd.nextLong();
        }
        res.value[res.wordLength - 1] = rnd.nextLong() >>> 64 - (length & 0x3F);
        return res;
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.toByteArray());
    }

    public static BitString square(BitString a) {
        BitString c = new BitString(a.bitLength * 2 - 1);
        for (int i = 0; i < a.wordLength - 1; ++i) {
            long ai = a.value[i];
            c.value[2 * i] = (long)T[(int)(ai >> 24) & 0xFF] << 48 | (long)T[(int)(ai >> 16) & 0xFF] << 32 | (long)T[(int)(ai >> 8) & 0xFF] << 16 | (long)T[(int)ai & 0xFF];
            c.value[2 * i + 1] = (long)T[(int)(ai >> 56) & 0xFF] << 48 | (long)T[(int)(ai >> 48) & 0xFF] << 32 | (long)T[(int)(ai >> 40) & 0xFF] << 16 | (long)T[(int)(ai >> 32) & 0xFF];
        }
        long ai = a.value[a.wordLength - 1];
        c.value[2 * (a.wordLength - 1)] = (long)T[(int)(ai >> 24) & 0xFF] << 48 | (long)T[(int)(ai >> 16) & 0xFF] << 32 | (long)T[(int)(ai >> 8) & 0xFF] << 16 | (long)T[(int)ai & 0xFF];
        if (c.wordLength > 2 * (a.wordLength - 1) + 1) {
            c.value[2 * (a.wordLength - 1) + 1] = (long)T[(int)(ai >> 56) & 0xFF] << 48 | (long)T[(int)(ai >> 48) & 0xFF] << 32 | (long)T[(int)(ai >> 40) & 0xFF] << 16 | (long)T[(int)(ai >> 32) & 0xFF];
        }
        return c;
    }
}

