/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.util;

public class Base64 {
    private static final byte[] base64_lookup = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] base64_invlookup = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1};

    private Base64() {
    }

    public static String encode(byte[] input, int off, int len, boolean linebreaks) {
        int block;
        int olen = (len + 2) / 3 * 4;
        byte[] output = new byte[olen += linebreaks ? len * 4 / 3 / 80 : 0];
        int i = 0;
        int j = 0;
        int linelength = 0;
        while (i <= len - 3) {
            block = (input[i + off] << 24 >>> 8) + (input[i + off + 1] << 24 >>> 16) + (input[i + off + 2] << 24 >>> 24);
            output[j] = base64_lookup[block >>> 18 & 0x3F];
            output[j + 1] = base64_lookup[block >>> 12 & 0x3F];
            output[j + 2] = base64_lookup[block >>> 6 & 0x3F];
            output[j + 3] = base64_lookup[block & 0x3F];
            i += 3;
            j += 4;
            if (!linebreaks || (linelength += 4) < 80) continue;
            output[j] = 10;
            ++j;
            linelength = 0;
        }
        if (i == len - 1) {
            block = input[i + off] << 24 >>> 8;
            output[j] = base64_lookup[block >>> 18 & 0x3F];
            output[j + 1] = base64_lookup[block >>> 12 & 0x3F];
            output[j + 2] = 61;
            output[j + 3] = 61;
            ++i;
            j += 4;
        }
        if (i == len - 2) {
            block = (input[i + off] << 24 >>> 8) + (input[i + off + 1] << 24 >>> 16);
            output[j] = base64_lookup[block >>> 18 & 0x3F];
            output[j + 1] = base64_lookup[block >>> 12 & 0x3F];
            output[j + 2] = base64_lookup[block >>> 6 & 0x3F];
            output[j + 3] = 61;
            i += 2;
            j += 4;
        }
        return new String(output);
    }

    public static String encode(byte[] input, int off, int len) {
        return Base64.encode(input, off, len, true);
    }

    public static String encode(byte[] input, boolean linebreaks) {
        return Base64.encode(input, 0, input.length, linebreaks);
    }

    public static String encode(byte[] input) {
        return Base64.encode(input, 0, input.length, true);
    }

    public static byte[] decode(byte[] input, int off, int len) throws Base64Exception {
        byte[] output = new byte[len * 3 / 4];
        int i = 0;
        int j = 0;
        boolean finished = false;
        int num = 0;
        int word = 0;
        while (i < len) {
            if (input[i + off] == 9 || input[i + off] == 32 || input[i + off] == 13 || input[i + off] == 10) {
                ++i;
                continue;
            }
            if (input[i + off] == 61) {
                ++i;
                if (finished) continue;
                if (num <= 1) {
                    throw new Base64Exception("Invalid Base64 (bad ending)");
                }
                if (num == 2) {
                    output[j] = (byte)(word >>> 4 & 0xFF);
                    ++j;
                    finished = true;
                    continue;
                }
                output[j] = (byte)(word >>> 10 & 0xFF);
                output[j + 1] = (byte)(word >>> 2 & 0xFF);
                j += 2;
                finished = true;
                continue;
            }
            if (finished) {
                throw new Base64Exception("Invalid Base64 (bad ending - non-'=' characters)");
            }
            if ((input[i] & 0x80) != 0) {
                throw new Base64Exception("Invalid Base64 (invalic character :" + input[j] + ")");
            }
            byte index = base64_invlookup[input[i]];
            if (index == -1) {
                throw new Base64Exception("Invalid Base64 (invalic character :" + input[j] + ")");
            }
            ++i;
            word = word << 6 | index;
            if (++num != 4) continue;
            output[j] = (byte)(word >>> 16 & 0xFF);
            output[j + 1] = (byte)(word >>> 8 & 0xFF);
            output[j + 2] = (byte)(word & 0xFF);
            j += 3;
            word = 0;
            num = 0;
        }
        byte[] res = new byte[j];
        System.arraycopy(output, 0, res, 0, j);
        return res;
    }

    public static byte[] decode(String input) throws Base64Exception {
        byte[] byteinput = input.getBytes();
        return Base64.decode(byteinput, 0, byteinput.length);
    }

    public static class Base64Exception
    extends Exception {
        public Base64Exception(String message) {
            super(message);
        }
    }
}

