/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class Utils {
    protected static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n >>> 24 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public static void writeCommandNumber(int n, OutputStream outputStream) throws IOException {
        Utils.writeInt(n, outputStream);
    }

    public static void writeString(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        Utils.writeInt(n, outputStream);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            outputStream.write(cArray[i]);
        }
    }

    public static void writeByteArray(byte[] byArray, OutputStream outputStream) throws IOException {
        Utils.writeInt(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeDate(Date date, OutputStream outputStream) throws IOException {
        long l = date.getTime() / 1000L;
        long l2 = l / 86400L;
        long l3 = l % 86400L;
        if (l3 < 0L) {
            l3 += 86400L;
            --l2;
        }
        if ((l2 += 25202L) < 0L) {
            throw new IOException("Invalid date format");
        }
        int n = (int)l2;
        int n2 = (int)l3;
        Utils.writeInt(n, outputStream);
        Utils.writeInt(n2, outputStream);
    }

    public static String readString(InputStream inputStream) throws IOException {
        int n;
        int n2 = Utils.readInt(inputStream);
        if (n2 < 0) {
            throw new IOException("Invalid length of string: " + n2);
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            if (n != -1) continue;
            throw new IOException("End of stream.");
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)byArray[n3];
            int n4 = n3++;
            cArray[n4] = (char)(cArray[n4] & 0xFF);
        }
        String string = new String(cArray);
        return string;
    }

    public static byte readByte(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1];
        inputStream.read(byArray, 0, 1);
        return byArray[0];
    }

    public static byte[] readByteArray(InputStream inputStream) throws IOException {
        int n;
        int n2 = Utils.readInt(inputStream);
        if (n2 < 0) {
            throw new IOException("End of stream.");
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            if (n != -1) continue;
            throw new IOException("End of stream.");
        }
        return byArray;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                throw new IOException("End of stream reached.");
            }
            n |= (n2 & 0xFF) << 24 - i * 8;
        }
        return n;
    }

    public static int readSizedInt(InputStream inputStream) throws IOException {
        int n = Utils.readInt(inputStream);
        if (n != 4) {
            throw new IOException("Integer size error in stream.");
        }
        return Utils.readInt(inputStream);
    }

    public static Date readDate(InputStream inputStream) throws IOException {
        int n = Utils.readInt(inputStream);
        int n2 = Utils.readInt(inputStream);
        long l = (n - 25202) * 86400 + n2;
        return new Date(l * 1000L);
    }

    public static Date readSizedDate(InputStream inputStream) throws IOException {
        int n = Utils.readInt(inputStream);
        if (n != 8) {
            throw new IOException("Date size error in stream.");
        }
        int n2 = Utils.readInt(inputStream);
        int n3 = Utils.readInt(inputStream);
        long l = (n2 - 25202) * 86400 + n3;
        return new Date(l * 1000L);
    }

    public static String hexDump_html(byte[] byArray) {
        return Utils.hexDump_html(byArray, 0, byArray.length);
    }

    public static String hexDump_html(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n3 = n;
        while (n3 < n + n2) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer.append(Utils.hexify(n3 >>> 8 & 0xFF));
            stringBuffer.append(Utils.hexify(n3 & 0xFF));
            stringBuffer.append(":  ");
            int n4 = 0;
            while (n4 < 16) {
                if (n3 < byArray.length) {
                    int n5 = byArray[n3] & 0xFF;
                    stringBuffer.append(Utils.hexify(n5)).append(' ');
                    if (n5 == 60) {
                        stringBuffer2.append("&lt;");
                    } else if (n5 == 62) {
                        stringBuffer2.append("&gt;");
                    } else if (n5 == 38) {
                        stringBuffer2.append("&amp;");
                    } else {
                        stringBuffer2.append(n5 >= 32 && n5 < 127 ? (char)n5 : (char)'.');
                    }
                } else {
                    stringBuffer.append("   ");
                    stringBuffer2.append(" ");
                }
                ++n4;
                ++n3;
            }
            stringBuffer.append(' ').append(stringBuffer2).append("<br>");
        }
        return stringBuffer.toString();
    }

    public static String hexDump(byte[] byArray) {
        return Utils.hexDump(byArray, 0, byArray.length);
    }

    public static String hexDump(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "null";
        }
        char[] cArray = new char[16];
        StringBuffer stringBuffer = new StringBuffer(256);
        int n3 = n;
        while (n3 < n + n2) {
            stringBuffer.append(Utils.hexify(n3 >>> 8 & 0xFF));
            stringBuffer.append(Utils.hexify(n3 & 0xFF));
            stringBuffer.append(":  ");
            int n4 = 0;
            while (n4 < 16) {
                if (n3 < byArray.length) {
                    int n5 = byArray[n3] & 0xFF;
                    stringBuffer.append(Utils.hexify(n5)).append(' ');
                    cArray[n4] = n5 >= 32 && n5 < 127 ? (int)n5 : 46;
                } else {
                    stringBuffer.append("   ");
                    cArray[n4] = 32;
                }
                ++n4;
                ++n3;
            }
            stringBuffer.append(' ').append(cArray).append('\n');
        }
        return stringBuffer.toString();
    }

    public static String hexEncode(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return Base64.encodeBytes(byArray);
    }

    public static byte[] hexDecode(String string) {
        return Base64.decode(string);
    }

    public static String hexify(int n) {
        return hexChars[(n & 0xFF & 0xF0) >>> 4] + hexChars[n & 0xF];
    }

    public static byte[] toByteArray(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (bl) {
            ++n;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        if (bl) {
            byArray[byArray.length - 1] = 0;
        }
        return byArray;
    }

    protected static byte[] toByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(n >>> 8 * (3 - i) & 0xFF);
        }
        return byArray;
    }
}

