/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.CommandOutputStream;
import com.cryptomathic.ss.customer.ResponseInputStream;
import com.cryptomathic.ss.customer.SignerException;
import com.cryptomathic.ss.customer.SignerKeyPair;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SignerSignature {
    private byte[] _message = null;
    private String _summary = null;
    private byte[] _digest = null;
    private byte[] _signature = null;
    private boolean _isHash = true;
    private SIG_FORMAT _format = SIG_FORMAT.PKCS1;
    private String _hashAlgo = "SHA";
    private SignerKeyPair _kp = null;

    public void setKeyPair(SignerKeyPair signerKeyPair) {
        this._kp = signerKeyPair;
    }

    public SignerKeyPair getKeyPair() {
        return this._kp;
    }

    public void setIsDigest(boolean bl) {
        this._isHash = bl;
    }

    public void setFormat(SIG_FORMAT sIG_FORMAT) {
        this._format = sIG_FORMAT;
    }

    public void setHashAlgo(String string) {
        if (string.equalsIgnoreCase("SHA")) {
            this._hashAlgo = "SHA";
        } else if (string.equalsIgnoreCase("MD4")) {
            this._hashAlgo = "MD4";
        } else if (string.equalsIgnoreCase("MD5")) {
            this._hashAlgo = "MD5";
        } else if (string.equalsIgnoreCase("RIPEMD160")) {
            this._hashAlgo = "RIPEMD160";
        } else if (string.equalsIgnoreCase("MDC2")) {
            this._hashAlgo = "MDC2";
        }
    }

    public SignerSignature(byte[] byArray, String string, SIG_FORMAT sIG_FORMAT, String string2) {
        this._summary = string;
        if (sIG_FORMAT == SIG_FORMAT.PKCS1_RAW) {
            this._digest = byArray;
            string2 = null;
        } else {
            this._message = byArray;
            this.setHashAlgo(string2);
        }
        this.setFormat(sIG_FORMAT);
    }

    public SignerSignature(String string, String string2, SIG_FORMAT sIG_FORMAT, String string3) {
        this(string.getBytes(), string2, sIG_FORMAT, string3);
    }

    public SignerSignature(String string, String string2) {
        this(string, string2, SIG_FORMAT.PKCS1, "");
    }

    public SignerSignature(byte[] byArray, String string) {
        this(byArray, string, SIG_FORMAT.PKCS1_RAW, "");
    }

    public void makeHash() throws SignerException {
        if (this._format != SIG_FORMAT.PKCS1_RAW) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this._hashAlgo);
                messageDigest.reset();
                messageDigest.update(this._message);
                this._digest = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SignerException("No provider for algorithm: " + this._hashAlgo);
            }
        }
    }

    CommandOutputStream packSignCommand(String string) throws SignerException {
        if (this._isHash && this._digest == null) {
            this.makeHash();
        }
        try {
            if (this._format == SIG_FORMAT.PKCS1) {
                return this.packCommand_pkcs1(string);
            }
            if (this._format == SIG_FORMAT.PKCS1_RAW) {
                return this.packCommand_pkcs1raw(string);
            }
            if (this._format == SIG_FORMAT.PKCS7) {
                return this.packCommand_pkcs7(string);
            }
            if (this._format == SIG_FORMAT.ISO9796) {
                return this.packCommand_iso9796(string);
            }
            throw new SignerException("Unknown signature format");
        }
        catch (IOException iOException) {
            throw new SignerException("Could not create request: " + iOException.getMessage());
        }
    }

    CommandOutputStream packCommand_pkcs1(String string) throws SignerException, IOException {
        if (!this._isHash) {
            throw new SignerException("No message digest!");
        }
        CommandOutputStream commandOutputStream = new CommandOutputStream(11);
        commandOutputStream.setTagValue(9, this._digest);
        commandOutputStream.setTagValue(6, true);
        commandOutputStream.setTagValue(31, this._summary);
        this._kp.pack(12, commandOutputStream);
        commandOutputStream.setTagValue(10, this._hashAlgo);
        commandOutputStream.setTagValue(19, string);
        return commandOutputStream;
    }

    CommandOutputStream packCommand_pkcs1raw(String string) throws SignerException, IOException {
        if (!this._isHash) {
            throw new SignerException("No message digest!");
        }
        CommandOutputStream commandOutputStream = new CommandOutputStream(11);
        commandOutputStream.setTagValue(9, this._digest);
        commandOutputStream.setTagValue(6, false);
        commandOutputStream.setTagValue(31, this._summary);
        this._kp.pack(12, commandOutputStream);
        commandOutputStream.setTagValue(19, string);
        return commandOutputStream;
    }

    CommandOutputStream packCommand_pkcs7(String string) throws SignerException, IOException {
        if (this._isHash && this._digest == null) {
            throw new SignerException("No message digest!");
        }
        CommandOutputStream commandOutputStream = new CommandOutputStream(12);
        commandOutputStream.setTagValue(9, this._isHash ? this._digest : this._message);
        commandOutputStream.setTagValue(11, this._isHash);
        commandOutputStream.setTagValue(31, this._summary);
        this._kp.pack(12, commandOutputStream);
        commandOutputStream.setTagValue(10, this._hashAlgo);
        commandOutputStream.setTagValue(19, string);
        return commandOutputStream;
    }

    CommandOutputStream packCommand_iso9796(String string) throws SignerException, IOException {
        if (!this._isHash) {
            throw new SignerException("No message digest!");
        }
        CommandOutputStream commandOutputStream = new CommandOutputStream(13);
        commandOutputStream.setTagValue(9, this._digest);
        commandOutputStream.setTagValue(31, this._summary);
        this._kp.pack(12, commandOutputStream);
        commandOutputStream.setTagValue(19, string);
        return commandOutputStream;
    }

    void unpackSignResponse(ResponseInputStream responseInputStream) throws SignerException {
        try {
            int n;
            while (0 != (n = responseInputStream.readTag())) {
                if (30 == n) {
                    this._signature = responseInputStream.readByteArray();
                    continue;
                }
                throw new SignerException("Unknown tag encountered when unpacking");
            }
        }
        catch (IOException iOException) {
            throw new SignerException("Could not unpack response");
        }
    }

    public byte[] getSignature() {
        byte[] byArray = null;
        if (this._signature != null) {
            byArray = new byte[this._signature.length];
            System.arraycopy(this._signature, 0, byArray, 0, this._signature.length);
        }
        return byArray;
    }

    public byte[] getMessage() {
        byte[] byArray = new byte[this._message.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this._message[i];
        }
        return byArray;
    }

    public String getSummary() {
        return this._summary;
    }

    public SIG_FORMAT getFormat() {
        return this._format;
    }

    public String getDigestAlgorithm() {
        return this._hashAlgo;
    }

    public byte[] getHash() {
        byte[] byArray = null;
        if (this._digest != null) {
            byArray = new byte[this._digest.length];
            System.arraycopy(this._digest, 0, byArray, 0, this._digest.length);
        }
        return byArray;
    }

    public boolean isMessageDigest() {
        return this._isHash;
    }

    public static class SIG_FORMAT
    implements Serializable {
        private String name;
        public static final SIG_FORMAT PKCS1 = new SIG_FORMAT("PKCS1");
        public static final SIG_FORMAT PKCS7 = new SIG_FORMAT("PKCS7");
        public static final SIG_FORMAT ISO9796 = new SIG_FORMAT("ISO9796");
        public static final SIG_FORMAT PKCS1_RAW = new SIG_FORMAT("PKCS1Raw");

        private SIG_FORMAT(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

