/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.CommandOutputStream;
import com.cryptomathic.ss.customer.CustCommException;
import com.cryptomathic.ss.customer.ResponseInputStream;
import com.cryptomathic.ss.customer.SignerKeyUsage;
import java.io.IOException;

public class SignerPrivilege {
    private SignerKeyUsage usage;
    private Integer _caID;
    private Integer _policyID;
    public byte[] authInfo;
    public String policyDescription;

    public SignerPrivilege(int n, int n2) {
        this._policyID = new Integer(n);
        this._caID = new Integer(n2);
    }

    public SignerPrivilege(int n) {
        this._policyID = new Integer(n);
    }

    public SignerPrivilege() {
    }

    public boolean canExport() {
        return this.usage.canExport();
    }

    public boolean canSign() {
        return this.usage.canSign();
    }

    public boolean canDecrypt() {
        return this.usage.canDecrypt();
    }

    public boolean canImport() {
        return this.usage.canImport();
    }

    public boolean canImportCert() {
        return this.usage.canImportCert();
    }

    public boolean canCertify() {
        return this.usage.canCertify();
    }

    boolean hasInternCA() {
        return this._caID != null;
    }

    public static SignerPrivilege unpack(ResponseInputStream responseInputStream) throws IOException, CustCommException {
        int n;
        SignerPrivilege signerPrivilege = new SignerPrivilege();
        while (0 != (n = responseInputStream.readTag())) {
            if (42 == n) {
                int n2 = responseInputStream.readInt();
                continue;
            }
            if (43 == n) {
                signerPrivilege._policyID = new Integer(responseInputStream.readInt());
                continue;
            }
            if (2 == n) {
                signerPrivilege._caID = new Integer(responseInputStream.readInt());
                continue;
            }
            if (39 == n) {
                signerPrivilege.usage = new SignerKeyUsage(responseInputStream.readInt());
                continue;
            }
            if (40 == n) {
                signerPrivilege.policyDescription = responseInputStream.readString();
                continue;
            }
            if (41 == n) {
                signerPrivilege.authInfo = responseInputStream.readByteArray();
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
        return signerPrivilege;
    }

    public void pack(int n, CommandOutputStream commandOutputStream) throws IOException {
        commandOutputStream.setTag(n);
        if (this._policyID != null) {
            commandOutputStream.setTagValue(43, this._policyID);
        }
        if (this._caID != null) {
            commandOutputStream.setTagValue(2, this._caID);
        }
        commandOutputStream.setEndTag();
    }
}

