/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.CommandOutputStream;
import com.cryptomathic.ss.customer.CustCommException;
import com.cryptomathic.ss.customer.ResponseInputStream;
import com.cryptomathic.ss.customer.SignerKeyUsage;
import java.io.IOException;
import java.util.Date;

public class SignerKeyPair {
    private byte[] _cert;
    private SignerKeyUsage _privateKeyUsage;
    private Integer _caid;
    private Date _expirationDate;
    private Date _dateIssued;
    private Date _expiresBy;
    public Integer keyPairID;
    public String shortName;
    public byte[] authInfo;
    public int publicKeySize;
    public String publicKeyAlgorithm;
    public int publicKeyExponent;
    public String policyDescription;

    public long getAuthInfo() {
        long l = this.authInfo[0];
        for (int i = 1; i < 4; ++i) {
            l <<= 8;
            l += (long)this.authInfo[i];
        }
        return l;
    }

    public SignerKeyPair(String string, Date date, int n) {
        this.keyPairID = new Integer(n);
        this.shortName = string;
        this._expirationDate = date;
        this._privateKeyUsage = null;
        this._caid = null;
    }

    public SignerKeyPair() {
    }

    public SignerKeyPair(int n) {
        this.keyPairID = new Integer(n);
    }

    public SignerKeyPair(String string) {
        this.shortName = string;
    }

    public void setPublicKeyInfo(String string, int n, int n2) {
        this.publicKeyAlgorithm = string;
        this.publicKeySize = n;
        this.publicKeyExponent = n2;
    }

    public void setValidityPeriod(Date date, Date date2) {
        this._dateIssued = date;
        this._expiresBy = date2;
    }

    public void setCertificate(byte[] byArray) {
        this._cert = byArray;
    }

    public byte[] getCertificate() {
        return this._cert;
    }

    public boolean canExport() {
        return this._privateKeyUsage.canExport();
    }

    public boolean canSign() {
        return this._privateKeyUsage.canSign();
    }

    public boolean canDecrypt() {
        return this._privateKeyUsage.canDecrypt();
    }

    public boolean canImport() {
        return this._privateKeyUsage.canImport();
    }

    public boolean canImportCert() {
        return this._privateKeyUsage.canImportCert();
    }

    public boolean hasInternCA() {
        return this._caid != null;
    }

    public Date getExpirationDate() {
        return this._expirationDate;
    }

    public Date getDateIssued() {
        return this._dateIssued;
    }

    public Date getExpiresBy() {
        return this._expiresBy;
    }

    public void setValidDate(Date date) {
        this._expirationDate = date;
    }

    public boolean isExpired() {
        return this._expirationDate != null;
    }

    public String toString() {
        return this.shortName;
    }

    static SignerKeyPair unpack(ResponseInputStream responseInputStream) throws IOException, CustCommException {
        int n;
        SignerKeyPair signerKeyPair = new SignerKeyPair();
        while (0 != (n = responseInputStream.readTag())) {
            if (35 == n) {
                signerKeyPair.keyPairID = new Integer(responseInputStream.readInt());
                continue;
            }
            if (28 == n) {
                signerKeyPair.shortName = responseInputStream.readString();
                continue;
            }
            if (36 == n) {
                signerKeyPair._expirationDate = responseInputStream.readDate();
                continue;
            }
            if (37 == n) {
                signerKeyPair._expiresBy = responseInputStream.readDate();
                continue;
            }
            if (38 == n) {
                signerKeyPair._dateIssued = responseInputStream.readDate();
                continue;
            }
            if (64 == n) {
                signerKeyPair.publicKeyAlgorithm = responseInputStream.readString();
                continue;
            }
            if (65 == n) {
                signerKeyPair.publicKeySize = responseInputStream.readInt();
                continue;
            }
            if (66 == n) {
                signerKeyPair.publicKeyExponent = responseInputStream.readInt();
                continue;
            }
            if (39 == n) {
                signerKeyPair._privateKeyUsage = new SignerKeyUsage((byte)responseInputStream.readInt());
                continue;
            }
            if (40 == n) {
                signerKeyPair.policyDescription = responseInputStream.readString();
                continue;
            }
            if (41 == n) {
                signerKeyPair.authInfo = responseInputStream.readByteArray();
                continue;
            }
            if (2 == n) {
                signerKeyPair._caid = new Integer(responseInputStream.readInt());
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
        return signerKeyPair;
    }

    public void pack(int n, CommandOutputStream commandOutputStream) throws IOException {
        commandOutputStream.setTag(n);
        if (this.keyPairID != null) {
            commandOutputStream.setTagValue(35, this.keyPairID);
        }
        if (this.shortName != null) {
            commandOutputStream.setTagValue(28, this.shortName);
        }
        if (this._expirationDate != null) {
            commandOutputStream.setTagValue(36, this._expirationDate);
        }
        commandOutputStream.setEndTag();
    }

    public Integer getCAID() {
        return this._caid;
    }
}

