/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.CommandOutputStream;
import com.cryptomathic.ss.customer.CustCommException;
import com.cryptomathic.ss.customer.CustomerCommunication;
import com.cryptomathic.ss.customer.ProtectionException;
import com.cryptomathic.ss.customer.ResponseInputStream;
import com.cryptomathic.ss.customer.ServerErrorException;
import com.cryptomathic.ss.customer.SignerCertificationContext;
import com.cryptomathic.ss.customer.SignerException;
import com.cryptomathic.ss.customer.SignerKeyPair;
import com.cryptomathic.ss.customer.SignerPrivilege;
import com.cryptomathic.ss.customer.SignerSignature;
import com.cryptomathic.ss.customer.UserInfo;
import java.io.IOException;

public class SignerCommandLayer
extends CustomerCommunication {
    protected SignerCommandLayer() {
    }

    public static synchronized SignerCommandLayer getInstance() {
        return new SignerCommandLayer();
    }

    private void sendSimpleCommand(int n, String string) throws IOException, ProtectionException, CustCommException, ServerErrorException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(n);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
    }

    private void sendSimpleAnonymousCommand(int n) throws IOException, CustCommException, ServerErrorException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(n);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.sendAnonymous(commandOutputStream.toByteArray(), null));
        this.errorHandle(responseInputStream);
    }

    public void logOff(String string) throws IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(15);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.initiateProtocol();
    }

    public void ping(String string) throws IOException, CustCommException, ProtectionException, ServerErrorException {
        this.sendSimpleCommand(9, string);
    }

    public void pingAnonymous() throws IOException, CustCommException, ProtectionException, ServerErrorException {
        this.sendSimpleAnonymousCommand(9);
    }

    public void suspendCustomer(String string) throws IOException, CustCommException, ProtectionException, ServerErrorException {
        this.sendSimpleCommand(3, string);
    }

    public void sign(SignerSignature signerSignature, String string) throws SignerException, IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = signerSignature.packSignCommand(this.getPassword(string));
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        signerSignature.unpackSignResponse(responseInputStream);
    }

    public byte[] decrypt(SignerKeyPair signerKeyPair, byte[] byArray, String string) throws IOException, CustCommException, ProtectionException {
        int n;
        CommandOutputStream commandOutputStream = new CommandOutputStream(14);
        signerKeyPair.pack(12, commandOutputStream);
        commandOutputStream.setTagValue(5, byArray);
        commandOutputStream.setTagValue(19, this.getPassword(string));
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        byte[] byArray2 = null;
        while (0 != (n = responseInputStream.readTag())) {
            if (16 == n) {
                byArray2 = responseInputStream.readByteArray();
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
        return byArray2;
    }

    public byte[][] getKey(SignerKeyPair signerKeyPair, String string) throws IOException, CustCommException, ProtectionException {
        int n;
        CommandOutputStream commandOutputStream = new CommandOutputStream(16);
        signerKeyPair.pack(12, commandOutputStream);
        commandOutputStream.setTagValue(19, this.getPassword(string));
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        byte[][] byArrayArray = new byte[2][];
        while (0 != (n = responseInputStream.readTag())) {
            if (21 == n) {
                byArrayArray[0] = responseInputStream.readByteArray();
                continue;
            }
            if (24 == n) {
                byArrayArray[1] = responseInputStream.readByteArray();
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
        return byArrayArray;
    }

    public void putKey(SignerPrivilege signerPrivilege, byte[] byArray, String string, String string2, String string3) throws IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(24);
        signerPrivilege.pack(22, commandOutputStream);
        commandOutputStream.setTagValue(13, byArray);
        commandOutputStream.setTagValue(14, string);
        commandOutputStream.setTagValue(28, string2);
        commandOutputStream.setTagValue(19, this.getPassword(string3));
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string3));
        this.errorHandle(responseInputStream);
    }

    public SignerKeyPair[] getKeyPairs(String string) throws IOException, CustCommException, ProtectionException {
        int n;
        if (!this.isProtected() && string != null) {
            throw new ProtectionException("Not protected");
        }
        CommandOutputStream commandOutputStream = new CommandOutputStream(10);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        SignerKeyPair[] signerKeyPairArray = null;
        while (0 != (n = responseInputStream.readTag())) {
            int n2;
            if (15 == n) {
                signerKeyPairArray = new SignerKeyPair[responseInputStream.readInt()];
                for (n2 = 0; n2 < signerKeyPairArray.length; ++n2) {
                    if (12 != responseInputStream.readTag()) {
                        throw new CustCommException("Unexpected tag encountered when deserialising response");
                    }
                    signerKeyPairArray[n2] = SignerKeyPair.unpack(responseInputStream);
                }
                continue;
            }
            if (23 == n) {
                SignerPrivilege[] signerPrivilegeArray = new SignerPrivilege[responseInputStream.readInt()];
                for (n2 = 0; n2 < signerPrivilegeArray.length; ++n2) {
                    if (22 != responseInputStream.readTag()) {
                        throw new CustCommException("Unexpected tag encountered when deserialising response");
                    }
                    signerPrivilegeArray[n2] = SignerPrivilege.unpack(responseInputStream);
                }
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
        return signerKeyPairArray;
    }

    public SignerPrivilege[] getPrivileges(String string) throws IOException, CustCommException, ProtectionException {
        int n;
        if (!this.isProtected() && string != null) {
            throw new ProtectionException("Not protected");
        }
        CommandOutputStream commandOutputStream = new CommandOutputStream(10);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        SignerPrivilege[] signerPrivilegeArray = null;
        while (0 != (n = responseInputStream.readTag())) {
            int n2;
            if (15 == n) {
                SignerKeyPair[] signerKeyPairArray = new SignerKeyPair[responseInputStream.readInt()];
                for (n2 = 0; n2 < signerKeyPairArray.length; ++n2) {
                    if (12 != responseInputStream.readTag()) {
                        throw new CustCommException("Unexpected tag encountered when deserialising response");
                    }
                    signerKeyPairArray[n2] = SignerKeyPair.unpack(responseInputStream);
                }
                continue;
            }
            if (23 == n) {
                signerPrivilegeArray = new SignerPrivilege[responseInputStream.readInt()];
                for (n2 = 0; n2 < signerPrivilegeArray.length; ++n2) {
                    if (22 != responseInputStream.readTag()) {
                        throw new CustCommException("Unexpected tag encountered when deserialising response");
                    }
                    signerPrivilegeArray[n2] = SignerPrivilege.unpack(responseInputStream);
                }
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
        return signerPrivilegeArray;
    }

    public void changeSignatureKey(SignerKeyPair signerKeyPair, String string) throws IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(1);
        signerKeyPair.pack(12, commandOutputStream);
        commandOutputStream.setTagValue(19, this.getPassword(string));
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
    }

    public byte[] getCACertificate(int n, String string) throws IOException, CustCommException, ProtectionException {
        int n2;
        CommandOutputStream commandOutputStream = new CommandOutputStream(27);
        commandOutputStream.setTagValue(2, n);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        byte[] byArray = null;
        while (0 != (n2 = responseInputStream.readTag())) {
            if (4 == n2) {
                byArray = responseInputStream.readByteArray();
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
        return byArray;
    }

    public void getCertificate(SignerKeyPair signerKeyPair, String string) throws IOException, CustCommException, ProtectionException {
        int n;
        CommandOutputStream commandOutputStream = new CommandOutputStream(8);
        signerKeyPair.pack(12, commandOutputStream);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        while (0 != (n = responseInputStream.readTag())) {
            if (4 == n) {
                signerKeyPair.setCertificate(responseInputStream.readByteArray());
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
    }

    public void putCertificate(SignerKeyPair signerKeyPair, byte[] byArray, String string) throws IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(23);
        signerKeyPair.pack(12, commandOutputStream);
        commandOutputStream.setTagValue(4, byArray);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
    }

    public UserInfo getUserInfo(String string) throws IOException, CustCommException, ProtectionException {
        int n;
        CommandOutputStream commandOutputStream = new CommandOutputStream(6);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        UserInfo userInfo = null;
        while (0 != (n = responseInputStream.readTag())) {
            if (33 == n) {
                userInfo = responseInputStream.readUserInfo();
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
        return userInfo;
    }

    public void setUserInfo(UserInfo userInfo, String string) throws IOException, CustCommException, ProtectionException, ServerErrorException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(7);
        commandOutputStream.setTagValue(33, userInfo);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
    }

    public void assignOTPCard(String string, String string2) throws IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(17);
        commandOutputStream.setTagValue(3, string);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string2));
        this.errorHandle(responseInputStream);
    }

    public void cancelOTPCards(String string) throws IOException, CustCommException, ProtectionException, ServerErrorException {
        this.sendSimpleCommand(18, string);
    }

    public void requestOTPCard(boolean bl, String string) throws IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(19);
        commandOutputStream.setTagValue(1, bl);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
    }

    public void updateSMSOTP(boolean bl, String string) throws IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(20);
        commandOutputStream.setTagValue(34, bl);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
    }

    public void uploadFpTemplate(byte[] byArray, String string) throws IOException, CustCommException, ProtectionException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(26);
        commandOutputStream.setTagValue(8, byArray);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
    }

    public void certPreregistration(SignerCertificationContext signerCertificationContext, String string) throws IOException, CustCommException, ProtectionException {
        int n;
        CommandOutputStream commandOutputStream = new CommandOutputStream(28);
        signerCertificationContext.getPrivilege().pack(22, commandOutputStream);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        while (0 != (n = responseInputStream.readTag())) {
            if (20 == n) {
                signerCertificationContext.setPreregistation(responseInputStream.readByteArray());
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
    }

    public void certGenerateRequest(SignerCertificationContext signerCertificationContext, String string) throws IOException, CustCommException, ProtectionException {
        int n;
        CommandOutputStream commandOutputStream = new CommandOutputStream(29);
        signerCertificationContext.getPrivilege().pack(22, commandOutputStream);
        commandOutputStream.setTagValue(20, signerCertificationContext.getPreregistration());
        commandOutputStream.setTagValue(24, signerCertificationContext.getPublicKey());
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        while (0 != (n = responseInputStream.readTag())) {
            if (25 == n) {
                signerCertificationContext.setRequest(responseInputStream.readByteArray());
                continue;
            }
            if (32 == n) {
                signerCertificationContext.setTBS(responseInputStream.readByteArray());
                continue;
            }
            if (29 == n) {
                signerCertificationContext.setSignAlgo(responseInputStream.readInt());
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response");
        }
    }

    public byte[] certify(SignerCertificationContext signerCertificationContext, String string) throws IOException, CustCommException, ProtectionException {
        int n;
        CommandOutputStream commandOutputStream = new CommandOutputStream(30);
        signerCertificationContext.getPrivilege().pack(22, commandOutputStream);
        commandOutputStream.setTagValue(20, signerCertificationContext.getPreregistration());
        commandOutputStream.setTagValue(25, signerCertificationContext.getRequest());
        commandOutputStream.setTagValue(30, signerCertificationContext.getPOP());
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string));
        this.errorHandle(responseInputStream);
        byte[] byArray = null;
        while (0 != (n = responseInputStream.readTag())) {
            if (4 == n) {
                byArray = responseInputStream.readByteArray();
                continue;
            }
            throw new CustCommException("Unexpected tag encountered when deserialising response: " + n);
        }
        return byArray;
    }
}

