/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.Base64;
import com.cryptomathic.ss.customer.CustCommException;
import com.cryptomathic.ss.customer.ProtectionException;
import com.cryptomathic.ss.customer.ServletInputOutputStream;
import com.cryptomathic.ss.customer.SignerCommandLayer;
import com.cryptomathic.ss.customer.SignerKeyPair;
import com.cryptomathic.ss.customer.SignerSignature;
import com.cryptomathic.ss.customer.UserInfo;
import com.cryptomathic.ss.customer.Utils;
import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;

public class SignerApplet
extends Applet {
    SignerKeyPair keyPairCache = null;
    protected SignerSignature es = null;
    private UserInfo userInfo = null;
    protected SignerCommandLayer c = null;
    protected int protSpec = -1;
    private byte[] challenge = null;
    private byte[] cert = null;
    private String lastErrorString = "";

    public int AUTH_METHOD_NONE() {
        return 0;
    }

    public int AUTH_METHOD_STORED_OTP() {
        return 1;
    }

    public int AUTH_METHOD_ONLINE_OTP_1() {
        return 16;
    }

    public int AUTH_METHOD_DIGIPASS_RO() {
        return 256;
    }

    public int AUTH_METHOD_DIGIPASS_CR() {
        return 512;
    }

    public int SIGN_RESULT_OK() {
        return 0;
    }

    public int SIGN_RESULT_AUTH_FAILED() {
        return 1;
    }

    public int SIGN_RESULT_IOEXCEPTION() {
        return 2;
    }

    public int SIGN_RESULT_UNKNOWNEXCEPTION() {
        return 3;
    }

    public int SIGN_RESULT_INVALIDMETHOD() {
        return 4;
    }

    public String getLastErrorString() {
        return this.lastErrorString;
    }

    public boolean logOn(String string, String string2, int n, boolean bl) {
        System.out.println("entering LogOn( " + string + " , " + string2 + " , " + n + " , " + bl + " )");
        try {
            this.keyPairCache = null;
            this.protSpec = n;
            this.c = new SignerCommandLayer();
            this.c.initialise(new ServletInputOutputStream(this.getParameter("ServletURL")));
            if (bl) {
                n |= 0x80;
            }
            this.c.logOn(string, string2, n);
            this.challenge = this.c.getChallenge();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean logOff(String string) {
        if (string == null || string.length() == 0) {
            string = null;
        }
        try {
            this.c.logOff(string);
            return true;
        }
        catch (IOException iOException) {
            this.lastErrorString = iOException.getMessage();
            return false;
        }
        catch (CustCommException custCommException) {
            this.lastErrorString = custCommException.getMessage();
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.lastErrorString = "Customer not logged in.";
            return false;
        }
        catch (Exception exception) {
            this.lastErrorString = "Unexpected exception : " + exception.getMessage();
            return false;
        }
    }

    public boolean protect(String string) {
        try {
            this.c.protect(string);
            return true;
        }
        catch (ProtectionException protectionException) {
            this.lastErrorString = protectionException.getMessage();
            return false;
        }
    }

    public int getDaysUntilPasswordExpires() {
        return this.c.getDaysUntilPasswordExpires();
    }

    public boolean changePassword(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            string2 = null;
        }
        if (string == null) {
            string = "";
        }
        try {
            this.c.changePassword(string, string2);
            return true;
        }
        catch (IOException iOException) {
            this.lastErrorString = iOException.getMessage();
            return false;
        }
        catch (CustCommException custCommException) {
            this.lastErrorString = custCommException.getMessage();
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.lastErrorString = "Customer not logged in.";
            return false;
        }
        catch (Exception exception) {
            this.lastErrorString = "Unexpected exception : " + exception.getMessage();
            return false;
        }
    }

    public boolean changeUnlockCode(String string, String string2) {
        try {
            this.c.changeUnlockCode(string, string2);
            return true;
        }
        catch (ProtectionException protectionException) {
            this.lastErrorString = protectionException.getMessage();
            return false;
        }
    }

    public boolean suspendCustomer(String string) {
        if (string == null || string.length() == 0) {
            string = null;
        }
        try {
            this.c.suspendCustomer(string);
            return true;
        }
        catch (IOException iOException) {
            this.lastErrorString = iOException.getMessage();
            return false;
        }
        catch (CustCommException custCommException) {
            this.lastErrorString = custCommException.getMessage();
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.lastErrorString = "Customer not logged in.";
            return false;
        }
        catch (Exception exception) {
            this.lastErrorString = "Unexpected exception : " + exception.getMessage();
            return false;
        }
    }

    public boolean getUserInfo(String string) {
        if (string == null || string.length() == 0) {
            string = null;
        }
        try {
            this.userInfo = this.c.getUserInfo(string);
            return true;
        }
        catch (IOException iOException) {
            this.lastErrorString = iOException.getMessage();
            return false;
        }
        catch (CustCommException custCommException) {
            this.lastErrorString = custCommException.getMessage();
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.lastErrorString = "Customer not logged in.";
            return false;
        }
        catch (Exception exception) {
            this.lastErrorString = "Unexpected exception : " + exception.getMessage();
            return false;
        }
    }

    public String getUserInfoField(String string) {
        if (this.userInfo == null) {
            this.lastErrorString = "User info is undefined.";
            return "<error>";
        }
        Field[] fieldArray = UserInfo.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equalsIgnoreCase(string)) continue;
            try {
                return (String)fieldArray[i].get(this.userInfo);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.lastErrorString = illegalAccessException.getMessage();
                return "<error>";
            }
        }
        this.lastErrorString = "Invalid field name.";
        return "<error>";
    }

    public boolean setUserInfoField(String string, String string2) {
        if (this.userInfo == null) {
            this.userInfo = new UserInfo();
        }
        if (string2 == null) {
            string2 = "";
        }
        Field[] fieldArray = UserInfo.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equalsIgnoreCase(string)) continue;
            try {
                fieldArray[i].set(this.userInfo, string2);
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.lastErrorString = illegalAccessException.getMessage();
                return false;
            }
        }
        this.lastErrorString = "Invalid field name.";
        return false;
    }

    public boolean updateUserInfo(String string) {
        if (string == null || string.length() == 0) {
            string = null;
        }
        if (this.userInfo == null) {
            this.lastErrorString = "User info is undefined.";
            return false;
        }
        try {
            this.c.setUserInfo(this.userInfo, string);
            return true;
        }
        catch (IOException iOException) {
            this.lastErrorString = iOException.getMessage();
            return false;
        }
        catch (CustCommException custCommException) {
            this.lastErrorString = custCommException.getMessage();
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.lastErrorString = "updateUserInfo: Customer not logged in.";
            return false;
        }
        catch (Exception exception) {
            this.lastErrorString = "Unexpected exception : " + exception.getMessage();
            return false;
        }
    }

    public boolean answerDigipassChallenge(String string) {
        try {
            this.c.answerDigipassChallenge(string);
            return true;
        }
        catch (CustCommException custCommException) {
            custCommException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public boolean answerChallenge(String string) {
        try {
            this.c.answerChallenge(string);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int sign2(String string, String string2, String string3, String string4) {
        if (string3.equals("PKCS1")) {
            return this.sign(string, string2, SignerSignature.SIG_FORMAT.PKCS1, string4);
        }
        if (string3.equals("PKCS7")) {
            return this.sign(string, string2, SignerSignature.SIG_FORMAT.PKCS7, string4);
        }
        if (string3.equals("ISO9796")) {
            return this.sign(string, string2, SignerSignature.SIG_FORMAT.ISO9796, string4);
        }
        return this.SIGN_RESULT_INVALIDMETHOD();
    }

    public int sign(String string, String string2, SignerSignature.SIG_FORMAT sIG_FORMAT, String string3) {
        if (string3 == null || string3.length() == 0) {
            string3 = null;
        }
        System.out.println("selected method: <" + sIG_FORMAT + ">");
        this.es = new SignerSignature(string, string2, sIG_FORMAT, "SHA");
        if (sIG_FORMAT == SignerSignature.SIG_FORMAT.PKCS7) {
            this.es.setIsDigest(false);
        }
        try {
            if (this.keyPairCache == null) {
                SignerKeyPair[] signerKeyPairArray = this.c.getKeyPairs(string3);
                boolean bl = false;
                SignerKeyPair signerKeyPair = null;
                for (int i = 0; !bl && i < signerKeyPairArray.length; ++i) {
                    signerKeyPair = signerKeyPairArray[i];
                    bl = signerKeyPair.canSign() && !signerKeyPair.isExpired();
                }
                if (!bl) {
                    throw new CustCommException("No valid keys for signing");
                }
                this.keyPairCache = new SignerKeyPair(signerKeyPair.shortName);
            }
            this.es.setKeyPair(this.keyPairCache);
            this.c.sign(this.es, string3);
            return this.SIGN_RESULT_OK();
        }
        catch (CustCommException custCommException) {
            custCommException.printStackTrace();
            return this.SIGN_RESULT_AUTH_FAILED();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return this.SIGN_RESULT_IOEXCEPTION();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.SIGN_RESULT_UNKNOWNEXCEPTION();
        }
    }

    public boolean testLogon(String string) {
        if (string == null || string.length() == 0) {
            string = null;
        }
        try {
            this.c.ping(string);
            return true;
        }
        catch (CustCommException custCommException) {
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public byte[] getSignature() {
        return this.es.getSignature();
    }

    public String getSignature_base64() {
        return Base64.encodeBytes(this.es.getSignature());
    }

    public String getCertificate_base64() {
        return Base64.encodeBytes(this.cert);
    }

    public String getMessage_base64() {
        return Base64.encodeBytes(this.es.getMessage());
    }

    public String getSignature_encoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        if (this.es == null) {
            return "";
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.es);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
        return Utils.hexEncode(byteArrayOutputStream.toByteArray());
    }

    public byte[] getCertificate(String string) {
        if (this.cert != null) {
            return this.cert;
        }
        if (string == null || string.length() == 0) {
            string = null;
        }
        try {
            this.c.getCertificate(this.es.getKeyPair(), string);
            this.cert = this.es.getKeyPair().getCertificate();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CustCommException custCommException) {
        }
        catch (ProtectionException protectionException) {
            this.lastErrorString = protectionException.getMessage();
        }
        return this.cert;
    }

    public String getCertificate_encoded(String string) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (this.es == null) {
            return "";
        }
        byte[] byArray = this.getCertificate(string);
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
        return Utils.hexEncode(byteArrayOutputStream.toByteArray());
    }

    public String getChallenge_storedOTP(int n) {
        if ((this.protSpec & this.AUTH_METHOD_STORED_OTP()) == 0) {
            return "WRONG_AUTH_METHOD";
        }
        String string = null;
        String string2 = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.challenge);
            string = Utils.readString(byteArrayInputStream);
            string2 = Utils.readString(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "IOEXCEPTION";
        }
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return string2;
        }
        return "WRONG_CHALLENGEPART";
    }

    public String getChallenge_digipass() {
        if ((this.protSpec & this.AUTH_METHOD_DIGIPASS_CR()) == 0) {
            return "WRONG_AUTH_METHOD";
        }
        String string = "";
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.challenge);
            string = Utils.readString(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "IOEXCEPTION";
        }
        this.removeChallenge(4 + string.length());
        return string;
    }

    private void removeChallenge(int n) {
        byte[] byArray = new byte[this.challenge.length - n];
        for (int i = 0; i < this.challenge.length - n; ++i) {
            byArray[i] = this.challenge[n + i];
        }
        this.challenge = byArray;
    }

    public void reset() {
        if (this.c != null) {
            this.c.reset();
        }
    }
}

