/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputOutputStream {
    protected OutputStream out = null;
    protected InputStream in = null;

    public void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeString(String string) throws IOException {
        int n = string.length();
        this.writeInt(n);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            this.write(cArray[i]);
        }
    }

    public String readString() throws IOException {
        int n = this.readInt();
        if (n < 0) {
            throw new IOException("Invalid length of string: " + n);
        }
        byte[] byArray = new byte[n];
        int n2 = this.fillBuffer(byArray, 0, n);
        if (n2 != n) {
            throw new IOException("End of stream.");
        }
        char[] cArray = new char[n];
        int n3 = 0;
        while (n3 < n) {
            cArray[n3] = (char)byArray[n3];
            int n4 = n3++;
            cArray[n4] = (char)(cArray[n4] & 0xFF);
        }
        String string = new String(cArray);
        return string;
    }

    public int readInt() throws IOException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.read();
            if (n2 == -1) {
                throw new IOException("End of stream reached.");
            }
            n |= (n2 & 0xFF) << 24 - i * 8;
        }
        return n;
    }

    public byte[] getSessionID() {
        return new byte[0];
    }

    public void setSessionID(byte[] byArray) {
    }

    public InputOutputStream(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
    }

    public void commandDone() throws IOException {
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void mark(int n) {
        this.in.mark(n);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.fillBuffer(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.fillBuffer(byArray, n, n2);
    }

    private int fillBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.in.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) {
                continue;
            }
            return n3;
        }
        return n3;
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }
}

