/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ss.customer;

import com.cryptomathic.ss.customer.AuthUtils;
import com.cryptomathic.ss.customer.BadPasswordException;
import com.cryptomathic.ss.customer.CommandOutputStream;
import com.cryptomathic.ss.customer.CustCommException;
import com.cryptomathic.ss.customer.IllegalHostException;
import com.cryptomathic.ss.customer.InputOutputStream;
import com.cryptomathic.ss.customer.ParameterManager;
import com.cryptomathic.ss.customer.ProtectionException;
import com.cryptomathic.ss.customer.ResponseInputStream;
import com.cryptomathic.ss.customer.ServerErrorException;
import com.cryptomathic.ss.customer.SuspendedException;
import com.cryptomathic.ss.customer.Tags;
import com.cryptomathic.ss.customer.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class CustomerCommunication {
    protected InputOutputStream inout;
    protected AuthUtils authUtils = new AuthUtils();
    protected int authStep = 0;
    protected byte[] cnonce;
    protected byte[] snonce;
    protected byte[] challenge;
    protected boolean encResult;
    protected boolean isSessionKey;
    protected byte[] sessionKeys;
    protected int daysUntilPasswordExpires;
    protected int customerRole;
    protected boolean sendOTPCardID;
    protected String otpCardID;
    protected SecureRandom _random = new SecureRandom();
    public ParameterManager params;
    public static final int MAX_PWD_LENGTH = 40;
    private byte[] state_password = new byte[40];
    private byte[] state_prf = new byte[AuthUtils.getStateLength()];
    private boolean isProtected = false;
    private byte[] salt = null;
    private byte[] seed = null;

    public void seedRandomGenerator(byte[] byArray) {
        this._random.setSeed(byArray);
    }

    public int getDaysUntilPasswordExpires() {
        return this.daysUntilPasswordExpires;
    }

    protected CustomerCommunication() {
        this.params = new ParameterManager();
    }

    public void protect(String string) throws ProtectionException {
        if (this.authStep != 3) {
            throw new ProtectionException("Logon must be complete before protecting the state");
        }
        if (this.isProtected) {
            throw new ProtectionException("Already protected");
        }
        this.setPassword(this.getPassword(null), string);
        this.setPrfState(this.authUtils.getState(), string);
        this.authUtils.destroyState();
        this.isProtected = true;
    }

    public void changeUnlockCode(String string, String string2) throws ProtectionException {
        if (!this.isProtected) {
            throw new ProtectionException("Not protected.");
        }
        String string3 = this.getPassword(string);
        this.setPassword(string3, string2);
        byte[] byArray = this.getPrfState(string);
        this.setPrfState(byArray, string2);
    }

    public byte[] exportState() throws ProtectionException, IOException {
        return this.exportState(null);
    }

    public synchronized byte[] exportState(String string) throws ProtectionException, IOException {
        if (!this.isProtected) {
            if (string != null) {
                this.protect(string);
            } else {
                throw new ProtectionException("Not protected");
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utils.writeByteArray(this.state_password, byteArrayOutputStream);
        Utils.writeByteArray(this.state_prf, byteArrayOutputStream);
        Utils.writeByteArray(this.salt, byteArrayOutputStream);
        Utils.writeInt(this.daysUntilPasswordExpires, byteArrayOutputStream);
        Utils.writeInt(this.encResult ? 1 : 0, byteArrayOutputStream);
        Utils.writeInt(this.authUtils.getSessionID(), byteArrayOutputStream);
        Utils.writeByteArray(this.inout.getSessionID(), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public synchronized void importState(byte[] byArray) throws IOException {
        this.authUtils = new AuthUtils();
        this.authStep = 3;
        this.cnonce = null;
        this.snonce = null;
        this.isSessionKey = false;
        this.sessionKeys = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.state_password = Utils.readByteArray(byteArrayInputStream);
        this.state_prf = Utils.readByteArray(byteArrayInputStream);
        this.salt = Utils.readByteArray(byteArrayInputStream);
        this.daysUntilPasswordExpires = Utils.readInt(byteArrayInputStream);
        this.encResult = Utils.readInt(byteArrayInputStream) == 1;
        this.authUtils.setSessionID(Utils.readInt(byteArrayInputStream));
        this.inout.setSessionID(Utils.readByteArray(byteArrayInputStream));
        this.isProtected = true;
    }

    public String getPassword(String string) throws ProtectionException {
        byte[] byArray = new byte[this.state_password.length];
        System.arraycopy(this.state_password, 0, byArray, 0, this.state_password.length);
        if (string != null) {
            this.decrypt(byArray, string, 0);
        }
        for (int i = 0; i < this.state_password.length; ++i) {
            if (byArray[i] != 0) continue;
            return new String(byArray, 0, i);
        }
        throw new ProtectionException("Password not initialised");
    }

    private void setPassword(String string) {
        try {
            this.setPassword(string, null);
        }
        catch (ProtectionException protectionException) {
            protectionException.printStackTrace();
        }
    }

    protected void setPassword(String string, String string2) throws ProtectionException {
        this.clear(this.state_password);
        System.arraycopy(string.getBytes(), 0, this.state_password, 0, string.length());
        if (string2 != null) {
            this.encrypt(this.state_password, string2, 0);
        }
        if (this.isProtected) {
            byte[] byArray = this.getPrfState(string2);
            this.setPrfState(byArray, string2);
        }
    }

    private byte[] getPrfState(String string) throws ProtectionException {
        if (string == null) {
            throw new ProtectionException("An unlockcode must be provided to get the state");
        }
        byte[] byArray = new byte[this.state_prf.length];
        System.arraycopy(this.state_prf, 0, byArray, 0, this.state_prf.length);
        this.decrypt(byArray, string, this.state_password.length);
        return byArray;
    }

    private void setPrfState(byte[] byArray, String string) throws ProtectionException {
        if (string == null) {
            throw new ProtectionException("An unlockcode must be provided to store the state");
        }
        if (byArray.length != this.state_prf.length) {
            throw new ProtectionException("Invalid state length");
        }
        System.arraycopy(byArray, 0, this.state_prf, 0, this.state_prf.length);
        this.encrypt(this.state_prf, string, this.state_password.length);
    }

    private void encrypt(byte[] byArray, String string, int n) throws ProtectionException {
        if (this.salt == null) {
            throw new ProtectionException("Salt not initialised");
        }
        try {
            byte[] byArray2 = AuthUtils.hash(string.getBytes());
            AuthUtils authUtils = new AuthUtils(byArray2, this.salt);
            authUtils.PRF(n);
            AuthUtils.xor(byArray, authUtils.PRF(byArray.length), byArray);
        }
        catch (CustCommException custCommException) {
            throw new ProtectionException("Unable to encrypt: " + custCommException.getMessage());
        }
    }

    private void decrypt(byte[] byArray, String string, int n) throws ProtectionException {
        if (this.salt == null) {
            throw new ProtectionException("Salt not initialised");
        }
        try {
            byte[] byArray2 = AuthUtils.hash(string.getBytes());
            AuthUtils authUtils = new AuthUtils(byArray2, this.salt);
            authUtils.PRF(n);
            AuthUtils.xor(byArray, authUtils.PRF(byArray.length), byArray);
        }
        catch (CustCommException custCommException) {
            throw new ProtectionException("Unable to encrypt: " + custCommException.getMessage());
        }
    }

    private void clear(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public synchronized void initialise(InputOutputStream inputOutputStream) {
        if (this.isInitialised()) {
            this.reset();
        }
        this.inout = inputOutputStream;
        this.initiateProtocol();
    }

    public synchronized void initialise(InputStream inputStream, OutputStream outputStream) {
        this.initialise(new InputOutputStream(inputStream, outputStream));
    }

    public synchronized boolean isInitialised() {
        return this.inout != null;
    }

    public boolean isLoggedOn() {
        return this.authStep == 4 || this.authStep == 3;
    }

    public synchronized void reset() {
        this.inout = null;
        this.initiateProtocol();
    }

    public void initiateProtocol() {
        this.authStep = 0;
        this.sessionKeys = new byte[0];
        this.isSessionKey = false;
        this.sendOTPCardID = false;
        this.authUtils.destroyState();
        this.clear(this.state_password);
        this.clear(this.state_prf);
        this.salt = null;
        this.isProtected = false;
    }

    protected synchronized void incAuthStep() {
        ++this.authStep;
    }

    public synchronized byte[] send(byte[] byArray, String string) throws IOException, ProtectionException, CustCommException {
        boolean bl;
        if (this.authStep == 3) {
            this.incAuthStep();
        }
        if (this.authStep != 4) {
            throw new CustCommException("Authentication protocol did not finish correctly");
        }
        if (this.isProtected == (string == null)) {
            throw new ProtectionException("The state is " + (this.isProtected ? "" : "NOT ") + "protected");
        }
        if (this.isProtected) {
            this.authUtils.setState(this.getPrfState(string));
        }
        if (this.isSessionKey) {
            this.authUtils.perturb(this.seed);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(0);
        Utils.writeInt(this.authUtils.getSessionID(), byteArrayOutputStream);
        if (this.isSessionKey) {
            byteArrayOutputStream.write(12);
            byteArrayOutputStream.write(this.sessionKeys);
            this.sessionKeys = null;
            this.isSessionKey = false;
        }
        byteArrayOutputStream.write(8);
        Utils.writeByteArray(this.authUtils.encrypt(byArray), byteArrayOutputStream);
        if (this.params.hasRequest()) {
            byteArrayOutputStream.write(20);
            this.params.serialiseRequest(byteArrayOutputStream);
        }
        byteArrayOutputStream.close();
        this.inout.writeInt(byteArrayOutputStream.size());
        this.inout.write(byteArrayOutputStream.toByteArray());
        int n = this.inout.readInt();
        byte[] byArray2 = new byte[n];
        int n2 = this.inout.read(byArray2);
        if (n2 != n) {
            throw new IOException("Reached end-of-stream");
        }
        boolean bl2 = bl = (byArray2[0] & 0x80) != 0;
        if (bl) {
            byArray2[0] = (byte)(byArray2[0] & 0xFFFFFF7F);
            this.initiateProtocol();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        byte[] byArray3 = Utils.readByteArray(byteArrayInputStream);
        if (!bl) {
            if (this.encResult) {
                byArray3 = this.authUtils.decrypt(byArray3);
            }
            if (((InputStream)byteArrayInputStream).available() > 0) {
                if (((InputStream)byteArrayInputStream).read() != 20) {
                    this.missingTag((byte)17);
                }
                this.params.deserialiseParameters(byteArrayInputStream);
            }
        }
        if (this.isProtected) {
            this.setPrfState(this.authUtils.getState(), string);
            this.authUtils.destroyState();
        }
        this.inout.commandDone();
        return byArray3;
    }

    private void missingTag(byte by) throws CustCommException {
        throw new CustCommException("Missing tag " + by + " in server's response");
    }

    synchronized byte[] sendAnonymous(byte[] byArray, String string) throws IOException, CustCommException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(17);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        if (string == null || string.length() == 0) {
            string = null;
        }
        if (string != null) {
            byteArrayOutputStream.write(1);
            Utils.writeString(string, byteArrayOutputStream);
        }
        byteArrayOutputStream.write(15);
        byteArrayOutputStream.write(byArray);
        if (this.params.hasRequest()) {
            byteArrayOutputStream.write(20);
            this.params.serialiseRequest(byteArrayOutputStream);
        }
        byteArrayOutputStream.close();
        int n = byteArrayOutputStream.size();
        this.inout.writeInt(n |= Integer.MIN_VALUE);
        this.inout.write(byteArrayOutputStream.toByteArray());
        n = this.inout.readInt();
        byte[] byArray2 = new byte[n];
        int n2 = this.inout.read(byArray2);
        if (n2 != n) {
            throw new CustCommException("Unexpected end of stream reached");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        if (((InputStream)byteArrayInputStream).read() != 17) {
            this.missingTag((byte)17);
        }
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = ((InputStream)byteArrayInputStream).read();
        }
        if (nArray[0] != 3) {
            String string2 = "Unknown version: " + nArray[0];
            for (int i = 1; i < 4; ++i) {
                string2 = string2 + "." + nArray[i];
            }
            throw new CustCommException(string2);
        }
        byte[] byArray3 = Utils.readByteArray(byteArrayInputStream);
        if (((InputStream)byteArrayInputStream).available() > 0) {
            if (((InputStream)byteArrayInputStream).read() != 20) {
                this.missingTag((byte)17);
            }
            this.params.deserialiseParameters(byteArrayInputStream);
        }
        this.inout.commandDone();
        return byArray3;
    }

    String send(String string, String string2) throws IOException, CustCommException, ProtectionException {
        byte[] byArray = this.send(Utils.toByteArray(string, false), string2);
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            cArray[n] = (char)byArray[n];
            int n2 = n++;
            cArray[n2] = (char)(cArray[n2] & 0xFF);
        }
        return new String(cArray);
    }

    public void setOTPCard(String string) {
        this.otpCardID = string;
        this.sendOTPCardID = true;
    }

    public synchronized void logOn(String string, String string2, int n) throws IOException, CustCommException, BadPasswordException, SuspendedException {
        this.logOn(string, string2, Utils.toByteArray(n));
    }

    public synchronized void logOn(String string, String string2, byte[] byArray) throws IOException, CustCommException, BadPasswordException, SuspendedException {
        int n;
        if (string2 == null) {
            string2 = "";
        }
        this.setPassword(string2);
        if (this.authStep != 0) {
            throw new CustCommException("A user was already logged on");
        }
        if (byArray.length != 4) {
            throw new CustCommException("Protocol specification must be 4 bytes long.");
        }
        if (!this.isInitialised()) {
            throw new CustCommException("Not connected to Signature Server.");
        }
        this.setState(byArray);
        byte[] byArray2 = new byte[128];
        this._random.nextBytes(byArray2);
        this.cnonce = AuthUtils.hash(byArray2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(17);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(1);
        Utils.writeString(string, byteArrayOutputStream);
        byteArrayOutputStream.write(2);
        Utils.writeByteArray(this.cnonce, byteArrayOutputStream);
        byteArrayOutputStream.write(19);
        byteArrayOutputStream.write(this.CalculatePOP(string, string2));
        if (this.sendOTPCardID) {
            byteArrayOutputStream.write(9);
            Utils.writeString(this.otpCardID, byteArrayOutputStream);
            this.sendOTPCardID = false;
        }
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        Utils.writeByteArray(byArray3, byteArrayOutputStream2);
        byteArrayOutputStream2.close();
        byte[] byArray4 = byteArrayOutputStream2.toByteArray();
        this.inout.write(byArray4);
        this.incAuthStep();
        int n2 = this.inout.readInt();
        byte[] byArray5 = new byte[4 + n2];
        byArray5[0] = (byte)(n2 >>> 24 & 0xFF);
        byArray5[1] = (byte)(n2 >>> 16 & 0xFF);
        byArray5[2] = (byte)(n2 >>> 8 & 0xFF);
        byArray5[3] = (byte)(n2 & 0xFF);
        int n3 = this.inout.read(byArray5, 4, n2);
        if (n3 != n2) {
            throw new CustCommException("Unexpected end of stream reached");
        }
        this.inout.commandDone();
        InputOutputStream inputOutputStream = new InputOutputStream(new ByteArrayInputStream(byArray5), null);
        inputOutputStream.skip(4L);
        if (inputOutputStream.read() != 17) {
            this.missingTag((byte)17);
        }
        int[] nArray = new int[4];
        for (n = 0; n < 4; ++n) {
            nArray[n] = inputOutputStream.read();
        }
        if (nArray[0] != 3) {
            String string3 = "Unknown version: " + nArray[0];
            for (int i = 1; i < 4; ++i) {
                string3 = string3 + "." + nArray[i];
            }
            throw new CustCommException(string3);
        }
        int n4 = inputOutputStream.read();
        if (n4 != 18) {
            this.missingTag((byte)18);
        }
        if ((n = inputOutputStream.readInt()) != 0) {
            n4 = inputOutputStream.read();
            if (n4 != 20) {
                this.missingTag((byte)20);
            }
            this.params.deserialiseParameters(inputOutputStream.in);
        }
        if (n == 1) {
            this.authStep = 0;
            throw new BadPasswordException("Incorrect password");
        }
        if (n == 2) {
            this.authStep = 0;
            throw new SuspendedException("The user is suspended");
        }
        if (n == 9) {
            this.authStep = 0;
            int n5 = 0;
            Object object = this.params.get(Tags.CustComm_Parameter_ClientIP);
            if (object != null && object instanceof Integer) {
                n5 = (Integer)object;
            }
            throw new IllegalHostException("The user cannot connect from that host", n5);
        }
        if (n != 0) {
            this.authStep = 0;
            throw new CustCommException("Unexpected status code from server: " + n);
        }
        n4 = inputOutputStream.read();
        if (n4 != 4) {
            this.missingTag((byte)4);
        }
        int n6 = inputOutputStream.readInt();
        this.authUtils.setSessionID(n6);
        n4 = inputOutputStream.read();
        if (n4 != 5) {
            this.missingTag((byte)5);
        }
        this.snonce = new byte[20];
        n3 = inputOutputStream.read(this.snonce);
        if (n3 != 20) {
            throw new CustCommException("Unexpected end of stream reached");
        }
        this.salt = new byte[this.cnonce.length];
        byte[] byArray6 = new byte[this.cnonce.length];
        System.arraycopy(this.cnonce, 0, byArray6, 0, this.cnonce.length);
        AuthUtils.xor(byArray6, this.snonce, this.salt);
        n4 = inputOutputStream.read();
        if (n4 != 6) {
            this.missingTag((byte)6);
        }
        inputOutputStream.readString();
        n4 = inputOutputStream.read();
        if (n4 != 13) {
            this.missingTag((byte)13);
        }
        this.daysUntilPasswordExpires = inputOutputStream.readInt();
        n4 = inputOutputStream.read();
        if (n4 != 14) {
            this.missingTag((byte)14);
        }
        this.customerRole = inputOutputStream.readInt();
        n4 = inputOutputStream.read();
        if (n4 != 7) {
            this.missingTag((byte)7);
        }
        n2 = inputOutputStream.readInt();
        this.challenge = new byte[n2];
        if (n2 > 0 && (n3 = inputOutputStream.read(this.challenge)) != n2) {
            throw new CustCommException("Unexpected end of stream reached");
        }
        n4 = inputOutputStream.read();
        if (n4 != 20) {
            this.missingTag((byte)20);
        }
        this.params.deserialiseParameters(inputOutputStream.in);
        byte[] byArray7 = Utils.toByteArray(string, false);
        byte[] byArray8 = Utils.toByteArray(string2, false);
        byte[] byArray9 = AuthUtils.hash(AuthUtils.concat(byArray7, byArray8));
        this.authUtils.init(byArray9, byArray4);
        this.authUtils.perturb(byArray5);
        this.incAuthStep();
    }

    private byte CalculatePOP(String string, String string2) throws CustCommException {
        byte[] byArray = AuthUtils.concat(string.getBytes(), string2.getBytes());
        byte[] byArray2 = AuthUtils.hash(byArray);
        byte[] byArray3 = new byte[1 + this.cnonce.length];
        byArray3[0] = byArray2[0];
        System.arraycopy(this.cnonce, 0, byArray3, 1, this.cnonce.length);
        return AuthUtils.hash(byArray3)[0];
    }

    public byte[] getChallenge() throws CustCommException {
        if (this.authStep < 2) {
            throw new CustCommException("Challenge not received yet");
        }
        return this.challenge;
    }

    public int getRole() {
        return this.customerRole;
    }

    protected void setState(byte[] byArray) {
        this.encResult = (byArray[3] & 0x80) != 0;
    }

    public void answerChallenge(byte[] byArray) throws CustCommException {
        if (this.authStep == 2) {
            this.incAuthStep();
        }
        if (this.authStep != 3) {
            throw new CustCommException("Challenge must be answered in accordance with protocol");
        }
        this.authUtils.perturb(byArray);
        this.seed = this.authUtils.PRF();
    }

    public void answerDigipassChallenge(byte[] byArray) throws CustCommException, IOException {
        if (this.authStep == 2) {
            this.incAuthStep();
        }
        if (this.authStep != 3) {
            throw new CustCommException("Challenge must be answered in accordance with protocol");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.seed = this.authUtils.getDigipassTarget(byArray, byteArrayOutputStream, this.authUtils.PRF());
        this.sessionKeys = AuthUtils.concat(this.sessionKeys, byteArrayOutputStream.toByteArray());
        this.isSessionKey = true;
        AuthUtils.printByteArray("target", byteArrayOutputStream.toByteArray());
    }

    public void answerTotpChallenge(byte[] byArray) throws CustCommException, IOException {
        if (this.authStep == 2) {
            this.incAuthStep();
        }
        if (this.authStep != 3) {
            throw new CustCommException("Challenge must be answered in accordance with protocol");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.seed = this.authUtils.getTotpTarget(byArray, byteArrayOutputStream, this.authUtils.PRF());
        this.sessionKeys = AuthUtils.concat(this.sessionKeys, byteArrayOutputStream.toByteArray());
        this.isSessionKey = true;
        AuthUtils.printByteArray("target", byteArrayOutputStream.toByteArray());
    }

    public void answerChallenge(String string) throws CustCommException {
        if (string == null) {
            string = "";
        }
        this.answerChallenge(Utils.toByteArray(string, false));
    }

    public void answerDigipassChallenge(String string) throws CustCommException, IOException {
        this.answerDigipassChallenge(Utils.toByteArray(string, false));
    }

    public void answerTotpChallenge(String string) throws CustCommException, IOException {
        this.answerTotpChallenge(Utils.toByteArray(string, false));
    }

    public void answerFingerPrintChallenge(byte[] byArray) throws CustCommException, IOException {
        if (this.authStep == 2) {
            this.incAuthStep();
        }
        if (this.authStep != 3) {
            throw new CustCommException("Challenge must be answered in accordance with protocol");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.seed = this.authUtils.getFingerPrintTarget(byArray, byteArrayOutputStream, this.authUtils.PRF());
        this.sessionKeys = AuthUtils.concat(this.sessionKeys, byteArrayOutputStream.toByteArray());
        this.isSessionKey = true;
        AuthUtils.printByteArray("target", byteArrayOutputStream.toByteArray());
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    protected void errorHandle(ResponseInputStream responseInputStream) throws ServerErrorException {
        int n = responseInputStream.getErrorCode();
        if (n != 0) {
            ServerErrorException.throwServerException(n, responseInputStream.getErrorString());
        }
    }

    public void changePassword(String string, String string2) throws IOException, CustCommException, ProtectionException, ServerErrorException {
        CommandOutputStream commandOutputStream = new CommandOutputStream(5);
        commandOutputStream.setTagValue(18, this.getPassword(string2));
        commandOutputStream.setTagValue(17, string);
        commandOutputStream.close();
        ResponseInputStream responseInputStream = new ResponseInputStream(this.send(commandOutputStream.toByteArray(), string2));
        this.errorHandle(responseInputStream);
        this.setPassword(string, string2);
    }
}

