/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user.utils;

import com.cryptomathic.signer.api.common.types.AuthenticationLevel;
import com.cryptomathic.signer.api.common.types.KeyLevel;
import com.cryptomathic.signer.api.user.KeyEntry;
import com.cryptomathic.signer.api.user.PolicyEntry;
import com.cryptomathic.signer.sdk.user.DeserialisationException;
import com.cryptomathic.signer.sdk.user.SignerUserException;
import com.cryptomathic.signer.sdk.user.crypto.UserProtocolResponseTag;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedResponse {
    private ByteArrayInputStream bsi;
    private DataInputStream dsi;
    short lookAhead;
    long sessionId;

    public EncryptedResponse(long l, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 2] = -1;
        byArray2[byArray2.length - 1] = -1;
        this.bsi = new ByteArrayInputStream(byArray2);
        this.dsi = new DataInputStream(this.bsi);
        this.lookAhead = this.dsi.readShort();
    }

    private short peekNextTag() {
        return this.lookAhead;
    }

    public int getInt(UserProtocolResponseTag userProtocolResponseTag) throws IOException, SignerUserException {
        if (this.lookAhead != userProtocolResponseTag.getValue()) {
            throw new DeserialisationException(this.sessionId, "Unexpected tag occurred in encrypted response: " + this.lookAhead);
        }
        int n = this.dsi.readInt();
        if (n != 4) {
            throw new DeserialisationException(this.sessionId, "Expected length 4 for integer");
        }
        int n2 = this.dsi.readInt();
        this.lookAhead = this.dsi.readShort();
        return n2;
    }

    public long getLong(UserProtocolResponseTag userProtocolResponseTag) throws SignerUserException, IOException {
        if (this.lookAhead != userProtocolResponseTag.getValue()) {
            throw new DeserialisationException(this.sessionId, "Unexpected tag occurred in encrypted response: " + this.lookAhead);
        }
        int n = this.dsi.readInt();
        if (n != 8) {
            throw new DeserialisationException(this.sessionId, "Expected length 4 for integer");
        }
        long l = this.dsi.readLong();
        this.lookAhead = this.dsi.readShort();
        return l;
    }

    public byte getByte(UserProtocolResponseTag userProtocolResponseTag) throws SignerUserException, IOException {
        if (this.lookAhead != userProtocolResponseTag.getValue()) {
            throw new DeserialisationException(this.sessionId, "Unexpected tag occurred in encrypted response: " + this.lookAhead);
        }
        int n = this.dsi.readInt();
        if (n != 1) {
            throw new DeserialisationException(this.sessionId, "Expected length 1 for byte");
        }
        byte by = this.dsi.readByte();
        this.lookAhead = this.dsi.readShort();
        return by;
    }

    public boolean getBoolean(UserProtocolResponseTag userProtocolResponseTag) throws SignerUserException, IOException {
        return this.getByte(userProtocolResponseTag) != 0;
    }

    public String getString(UserProtocolResponseTag userProtocolResponseTag) throws SignerUserException, IOException {
        return new String(this.getBytes(userProtocolResponseTag), "UTF-8");
    }

    public byte[] getBytes(UserProtocolResponseTag userProtocolResponseTag) throws SignerUserException, IOException {
        if (this.lookAhead != userProtocolResponseTag.getValue()) {
            throw new DeserialisationException(this.sessionId, "Unexpected tag occurred in encrypted response: " + this.lookAhead);
        }
        int n = this.dsi.readInt();
        if (n < 0) {
            throw new DeserialisationException(this.sessionId, "Expected length >=0 for byte array");
        }
        byte[] byArray = new byte[n];
        this.dsi.read(byArray);
        this.lookAhead = this.dsi.readShort();
        return byArray;
    }

    private int getTL(UserProtocolResponseTag userProtocolResponseTag) throws SignerUserException, IOException {
        if (this.lookAhead != userProtocolResponseTag.getValue()) {
            throw new DeserialisationException(this.sessionId, "Unexpected tag occurred in encrypted response: " + this.lookAhead);
        }
        int n = this.dsi.readInt();
        this.lookAhead = this.dsi.readShort();
        return n;
    }

    public PolicyEntry getPolicyEntry(UserProtocolResponseTag userProtocolResponseTag) throws SignerUserException, IOException {
        int n;
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.id = this.getLong(UserProtocolResponseTag.POLICY_ID);
        policyEntry.name = this.getString(UserProtocolResponseTag.POLICY_NAME);
        policyEntry.authLevel = AuthenticationLevel.findByNetworkByte(this.getByte(UserProtocolResponseTag.POLICY_AUTH_LEVEL));
        policyEntry.keyLevel = KeyLevel.findByNetworkByte(this.getByte(UserProtocolResponseTag.POLICY_KEY_LEVEL));
        policyEntry.canSign = this.getBoolean(UserProtocolResponseTag.POLICY_CAN_SIGN);
        policyEntry.canDecrypt = this.getBoolean(UserProtocolResponseTag.POLICY_CAN_DECRYPT);
        policyEntry.enabled = this.getBoolean(UserProtocolResponseTag.POLICY_ENABLED);
        policyEntry.keys = new ArrayList<KeyEntry>();
        int n2 = this.getTL(UserProtocolResponseTag.KEY_LIST);
        for (int i = 0; i < n2; i += n + 6) {
            KeyEntry keyEntry = new KeyEntry();
            n = this.getTL(UserProtocolResponseTag.KEY_ENTRY);
            keyEntry.keyId = this.getLong(UserProtocolResponseTag.KEY_ID);
            keyEntry.publicKey = this.getBytes(UserProtocolResponseTag.KEY_PUBLIC_KEY);
            if (this.peekNextTag() == UserProtocolResponseTag.KEY_EXPIRED_DATE.getValue()) {
                keyEntry.optionalExpiredDate = this.getLong(UserProtocolResponseTag.KEY_EXPIRED_DATE);
            }
            if (this.peekNextTag() == UserProtocolResponseTag.KEY_CERTIFICATE.getValue()) {
                this.getTL(UserProtocolResponseTag.KEY_CERTIFICATE);
                keyEntry.certificateBytes = this.getBytes(UserProtocolResponseTag.KEY_CERT_BYTES);
                keyEntry.displayText = this.getString(UserProtocolResponseTag.KEY_CERT_DISPLAY_TEXT);
            }
            policyEntry.keys.add(keyEntry);
        }
        return policyEntry;
    }

    public List<PolicyEntry> getPolicyList(UserProtocolResponseTag userProtocolResponseTag) throws SignerUserException, IOException {
        if (this.lookAhead != userProtocolResponseTag.getValue()) {
            throw new DeserialisationException(this.sessionId, "Unexpected tag occurred in encrypted response: " + this.lookAhead);
        }
        int n = this.dsi.readInt();
        if (n < 0) {
            throw new DeserialisationException(this.sessionId, "Expected length >=0 for list");
        }
        this.lookAhead = this.dsi.readShort();
        ArrayList<PolicyEntry> arrayList = new ArrayList<PolicyEntry>();
        while (this.lookAhead != -1) {
            PolicyEntry policyEntry = this.getPolicyEntry(null);
            arrayList.add(policyEntry);
        }
        return arrayList;
    }
}

