/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user.crypto;

import com.cryptomathic.common.utils.ByteArrays;
import com.cryptomathic.crypto.conv.ConvException;
import com.cryptomathic.crypto.conv.ConvMech;
import com.cryptomathic.crypto.conv.ConvMode;
import com.cryptomathic.crypto.conv.ConvType;
import com.cryptomathic.crypto.pad.PadMode;
import com.cryptomathic.signer.sdk.user.crypto.DecryptFailedException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;

public class CryptoUtils {
    public static byte[] createSha256Digest(byte[] ... byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            for (byte[] byArray2 : byArray) {
                messageDigest.update(byArray2);
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Hash algorithm not available", noSuchAlgorithmException);
        }
    }

    public static byte[] createSha1Digest(byte[] ... byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            for (byte[] byArray2 : byArray) {
                messageDigest.update(byArray2);
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Hash algorithm not available", noSuchAlgorithmException);
        }
    }

    public static byte[] byteArrayXor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] createMac(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = ConvMech.conv_mes(ConvType.AES256, ConvMode.CBCE, PadMode.PKCS5, byArray, new byte[16], byArray2);
            return ByteArrays.extract(byArray3, byArray3.length - 16);
        }
        catch (ConvException convException) {
            throw new RuntimeException("Not able to create AES MAC");
        }
    }

    public static byte[] encrypt(byte[] byArray, byte[] byArray2) {
        try {
            return ConvMech.conv_mes(ConvType.AES256, ConvMode.CBCE, PadMode.PKCS5, byArray, new byte[16], byArray2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not encrypt", exception);
        }
    }

    public static byte[] decrypt(byte[] byArray, byte[] byArray2) throws DecryptFailedException {
        try {
            return ConvMech.conv_mes(ConvType.AES256, ConvMode.CBCD, PadMode.PKCS5, byArray, new byte[16], byArray2);
        }
        catch (Exception exception) {
            throw new DecryptFailedException("Could not decrypt", exception);
        }
    }

    public static byte[] rsaEncrypt(byte[] byArray, Key key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        return cipher.doFinal(byArray);
    }
}

