/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user.crypto;

import com.cryptomathic.signer.sdk.user.crypto.CryptoUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public class ClientSrp {
    private final BigInteger N;
    private final BigInteger g;
    private final BigInteger k;
    private final Random rand;
    private byte[] clientSideProof;
    private byte[] K;

    public ClientSrp(byte[] byArray, byte[] byArray2) {
        this.N = new BigInteger(1, byArray);
        this.g = new BigInteger(1, byArray2);
        this.k = new BigInteger(1, CryptoUtils.createSha256Digest(byArray, byArray2));
        this.rand = new SecureRandom();
    }

    public byte[] createPasswordHash(char[] cArray) {
        try {
            return CryptoUtils.createSha256Digest(new byte[][]{new String(cArray).getBytes("UTF-8")});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Cannot encode UTF-8 strings");
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] create33PasswordHash(String string, char[] cArray) {
        void var8_12;
        byte[] byArray = new byte[string.length()];
        int n = 0;
        for (char c : string.toCharArray()) {
            byArray[n] = (byte)(c & 0xFF);
            ++n;
        }
        byte[] byArray2 = new byte[cArray.length];
        n = 0;
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        boolean bl = false;
        while (var8_12 < n2) {
            char c = cArray2[var8_12];
            byArray2[n] = (byte)(c & 0xFF);
            ++n;
            ++var8_12;
        }
        return CryptoUtils.createSha1Digest(byArray, byArray2);
    }

    public byte[] createPasswordDerivedKey(char[] cArray) {
        try {
            return CryptoUtils.createSha256Digest(new byte[32], new String(cArray).getBytes("UTF-8"), new byte[32]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Cannot encode UTF-8 strings");
        }
    }

    public SrpStep1Result doClientSideSrp() {
        final BigInteger bigInteger = new BigInteger(256, this.rand);
        final BigInteger bigInteger2 = this.g.modPow(bigInteger, this.N);
        return new SrpStep1Result(){

            public BigInteger getLittleA() {
                return bigInteger;
            }

            public byte[] getBigA() {
                return bigInteger2.toByteArray();
            }
        };
    }

    public byte[] getClientSideSecret(String string, BigInteger bigInteger, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws SrpException {
        BigInteger bigInteger2 = new BigInteger(1, CryptoUtils.createSha256Digest(byArray, byArray2));
        BigInteger bigInteger3 = new BigInteger(1, CryptoUtils.createSha256Digest(byArray3, byArray4));
        BigInteger bigInteger4 = new BigInteger(1, byArray2);
        if (bigInteger4.compareTo(this.N) >= 0) {
            throw new SrpException("B >= N");
        }
        if (bigInteger4.mod(this.N).compareTo(BigInteger.ZERO) == 0) {
            throw new SrpException("B is 0 (mod) N");
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) == 0) {
            throw new SrpException("u == 0");
        }
        BigInteger bigInteger5 = this.k.multiply(this.g.modPow(bigInteger3, this.N)).mod(this.N);
        bigInteger5 = bigInteger4.subtract(bigInteger5).mod(this.N);
        bigInteger5 = bigInteger5.modPow(bigInteger.add(bigInteger2.multiply(bigInteger3)), this.N);
        this.K = CryptoUtils.createSha256Digest(new byte[][]{bigInteger5.toByteArray()});
        byte[] byArray5 = CryptoUtils.byteArrayXor(CryptoUtils.createSha256Digest(new byte[][]{this.N.toByteArray()}), CryptoUtils.createSha256Digest(new byte[][]{this.g.toByteArray()}));
        try {
            this.clientSideProof = CryptoUtils.createSha256Digest(byArray5, CryptoUtils.createSha256Digest(new byte[][]{string.getBytes("UTF-8")}), byArray3, byArray, byArray2, this.K);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SrpException("Failed to encode identity");
        }
        return this.K;
    }

    public byte[] getClientSideProof() {
        return this.clientSideProof;
    }

    public boolean verifyHostSideProof(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = CryptoUtils.createSha256Digest(byArray, this.clientSideProof, this.K);
        return Arrays.equals(byArray2, byArray3);
    }

    public static byte[] getEncKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        Arrays.fill(byArray2, (byte)0);
        return CryptoUtils.createSha256Digest(byArray, byArray2);
    }

    public static byte[] getMacKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        Arrays.fill(byArray2, (byte)1);
        return CryptoUtils.createSha256Digest(byArray, byArray2);
    }

    public static interface SrpStep1Result {
        public BigInteger getLittleA();

        public byte[] getBigA();
    }

    public static class SrpException
    extends Exception {
        public SrpException(String string) {
            super(string);
        }
    }
}

