/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user;

import com.cryptomathic.common.utils.FileUtils;
import com.cryptomathic.common.utils.Hex;
import com.cryptomathic.signer.api.common.authenticator.RSAKeyWithIdSimple;
import com.cryptomathic.signer.api.user.KeyEntry;
import com.cryptomathic.signer.api.user.PolicyEntry;
import com.cryptomathic.signer.api.user.errors.UserErrorCodes;
import com.cryptomathic.signer.api.user.message.AnonCommand;
import com.cryptomathic.signer.api.user.message.AnonCommandType;
import com.cryptomathic.signer.api.user.message.AnonResponse;
import com.cryptomathic.signer.api.user.message.MainCommand;
import com.cryptomathic.signer.api.user.message.MainResponse;
import com.cryptomathic.signer.api.user.message.SRPCommand;
import com.cryptomathic.signer.api.user.message.SRPResponse;
import com.cryptomathic.signer.api.user.message.UserCommand;
import com.cryptomathic.signer.api.user.message.UserCommandType;
import com.cryptomathic.signer.api.user.message.UserResponse;
import com.cryptomathic.signer.api.user.protocol.UserProtocol;
import com.cryptomathic.signer.common.exceptions.SignerException;
import com.cryptomathic.signer.common.protocol.Response;
import com.cryptomathic.signer.sdk.user.AuthenticationChallenge;
import com.cryptomathic.signer.sdk.user.AuthenticationSMSChallenge;
import com.cryptomathic.signer.sdk.user.SignerDecryption;
import com.cryptomathic.signer.sdk.user.SignerSignature;
import com.cryptomathic.signer.sdk.user.SignerUserException;
import com.cryptomathic.signer.sdk.user.crypto.BlindSignatures;
import com.cryptomathic.signer.sdk.user.crypto.ClientSrp;
import com.cryptomathic.signer.sdk.user.crypto.DecryptFailedException;
import com.cryptomathic.signer.sdk.user.crypto.KeyStateHandler;
import com.cryptomathic.signer.sdk.user.crypto.UserProtocolCommandTag;
import com.cryptomathic.signer.sdk.user.crypto.UserProtocolResponseTag;
import com.cryptomathic.signer.sdk.user.utils.AuthenticationToken;
import com.cryptomathic.signer.sdk.user.utils.AuthenticatorUtils;
import com.cryptomathic.signer.sdk.user.utils.EncryptedCommand;
import com.cryptomathic.signer.sdk.user.utils.EncryptedResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignerUserConnection {
    private static final int PROTOCOL_VERSION = 1;
    private final String host;
    private final int port;
    private final String url;
    private boolean isConnected;
    private ClientSrp srp;
    private Socket socket;
    private UserProtocol protocol;
    private KeyStateHandler keyState;
    private AuthLevel currentAuthLevel;
    private long sessionId;
    private String userLoggedOn = "";
    private RSAPublicKey ctk;
    private long ctkId;
    private HttpsURLConnection httpsConnection;
    private boolean authenticatorEnabled;

    private void throwArgException(String string, String string2) throws IllegalArgumentException {
        if (string == null || string.equals("")) {
            string = "<Unknown>";
        }
        throw new IllegalArgumentException("Illegal value for argument '" + string + "': " + string2);
    }

    public SignerUserConnection(String string, File file, File file2) throws FileNotFoundException, IOException {
        Pattern pattern;
        Matcher matcher;
        if (string == null) {
            this.throwArgException("url", "cannot be null");
        }
        if ("".equals(string)) {
            this.throwArgException("url", "cannot be an empty string");
        }
        if (file == null) {
            this.throwArgException("propertyFile", "cannot be null");
        }
        if ((matcher = (pattern = Pattern.compile("^signer://(.*):(\\d+)")).matcher(string)).find()) {
            this.url = "";
            this.host = matcher.group(1);
            this.port = Integer.valueOf(matcher.group(2));
        } else {
            this.url = string;
            this.host = "";
            this.port = 0;
        }
        this.isConnected = false;
        this.currentAuthLevel = AuthLevel.NONE;
        this.authenticatorEnabled = false;
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        byte[] byArray = Hex.decode(properties.getProperty("g"));
        byte[] byArray2 = Hex.decode(properties.getProperty("N"));
        this.setCtk(file2);
        this.srp = new ClientSrp(byArray2, byArray);
        this.protocol = new UserProtocol();
    }

    public SignerUserConnection(String string, byte[] byArray, byte[] byArray2) throws MalformedURLException {
        Pattern pattern;
        Matcher matcher;
        if (string == null) {
            this.throwArgException("url", "cannot be null");
        }
        if ("".equals(string)) {
            this.throwArgException("url", "cannot be an empty string");
        }
        if (byArray == null || byArray.length == 0) {
            this.throwArgException("NVal", "cannot be null or empty");
        }
        if (byArray2 == null || byArray2.length == 0) {
            this.throwArgException("gVal", "cannot be null or empty");
        }
        if ((matcher = (pattern = Pattern.compile("^signer://(.*):(\\d+)")).matcher(string)).find()) {
            this.url = "";
            this.host = matcher.group(1);
            this.port = Integer.valueOf(matcher.group(2));
        } else {
            this.url = string;
            this.host = "";
            this.port = 0;
        }
        this.authenticatorEnabled = false;
        this.isConnected = false;
        this.currentAuthLevel = AuthLevel.NONE;
        this.srp = new ClientSrp(byArray, byArray2);
        this.protocol = new UserProtocol();
    }

    public void setCtk(File file) throws IOException {
        if (file == null) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = FileUtils.readStreamAsBytes(fileInputStream);
        fileInputStream.close();
        this.setCtk(byArray);
    }

    public void setCtk(byte[] byArray) {
        long l;
        RSAPublicKey rSAPublicKey;
        if (byArray == null || byArray.length == 0) {
            this.throwArgException("ctkData", "cannot be null or empty");
        }
        try {
            RSAKeyWithIdSimple rSAKeyWithIdSimple = new RSAKeyWithIdSimple(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAKeyWithIdSimple.getModulus(), rSAKeyWithIdSimple.getPublicExponent());
            rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            l = rSAKeyWithIdSimple.getId();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to set Credentials Transport Key - expecting a byte array containing the exported key data from Authenticator");
        }
        this.ctk = rSAPublicKey;
        this.ctkId = l;
    }

    private void doHttpsConnectWorkAround() throws IOException, SignerUserException {
        NullPointerException nullPointerException = null;
        int n = 0;
        for (int i = 1; i <= 10; ++i) {
            try {
                this.httpsConnection.connect();
                n = i;
                break;
            }
            catch (NullPointerException nullPointerException2) {
                nullPointerException = nullPointerException2;
                continue;
            }
        }
        if (n == 0) {
            throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, 0L, "NULL pointer exception in HTTPS connect() 10 times", nullPointerException);
        }
    }

    private UserResponse sendReceive(UserCommand userCommand) throws IOException, SignerUserException {
        Response response;
        if (userCommand == null) {
            this.throwArgException("cmd", "cannot be null");
        }
        if (!this.isConnected) {
            throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, 0L, "Not connected to server", null);
        }
        try {
            if (this.httpsConnection != null) {
                URL uRL = new URL(this.url);
                this.httpsConnection = (HttpsURLConnection)uRL.openConnection();
                this.httpsConnection.setDoInput(true);
                this.httpsConnection.setDoOutput(true);
                this.httpsConnection.setRequestMethod("POST");
                this.doHttpsConnectWorkAround();
                this.protocol.serializeCommand(this.httpsConnection.getOutputStream(), userCommand);
                response = this.protocol.deserializeResponse(this.httpsConnection.getInputStream());
            } else {
                this.protocol.serializeCommand(this.socket.getOutputStream(), userCommand);
                response = this.protocol.deserializeResponse(this.socket.getInputStream());
            }
        }
        catch (SignerException signerException) {
            throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, 0L, UserErrorCodes.COMMUNICATION_ERROR.getDescription(), signerException);
        }
        return (UserResponse)response;
    }

    private AnonResponse sendReceiveAnon(AnonCommand anonCommand) throws IOException, SignerUserException {
        UserResponse userResponse = this.sendReceive(anonCommand);
        AnonResponse anonResponse = AnonResponse.fromUserResponse(userResponse);
        return anonResponse;
    }

    private EncryptedResponse sendReceiveEncryptedCommand(EncryptedCommand encryptedCommand) throws IOException, SignerUserException {
        if (encryptedCommand == null) {
            this.throwArgException("ec", "cannot be null");
        }
        if (this.sessionId == 0L || this.keyState == null) {
            throw new SignerUserException(UserErrorCodes.NOT_LOGGED_IN, 0L);
        }
        MainCommand mainCommand = new MainCommand(this.sessionId, this.keyState.encryptCommand(encryptedCommand.toByteArray()), 1);
        UserResponse userResponse = this.sendReceive(mainCommand);
        if (userResponse != null) {
            MainResponse mainResponse = MainResponse.fromUserResponse(userResponse);
            UserErrorCodes userErrorCodes = mainResponse.getUserErrorCode();
            if (userErrorCodes == UserErrorCodes.OK) {
                byte[] byArray;
                if (mainResponse.getEncryptedContent() == null || mainResponse.getEncryptedContent().length == 0) {
                    throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, this.sessionId);
                }
                try {
                    byArray = this.keyState.getVerifiedResponse(mainResponse.getEncryptedContent());
                }
                catch (DecryptFailedException decryptFailedException) {
                    throw new SignerUserException(UserErrorCodes.DESERIALISATION_ERROR, this.sessionId);
                }
                EncryptedResponse encryptedResponse = new EncryptedResponse(this.sessionId, byArray);
                int n = encryptedResponse.getInt(UserProtocolResponseTag.RETURN_CODE);
                UserErrorCodes userErrorCodes2 = UserErrorCodes.valueOf(n);
                if (userErrorCodes2 != UserErrorCodes.OK) {
                    if (userErrorCodes2 == UserErrorCodes.AUTHENTICATION_FAILED_FORCED_LOGOFF) {
                        this.setAuthLevel(0);
                    }
                    throw new SignerUserException(userErrorCodes2, this.sessionId);
                }
                byte by = encryptedResponse.getByte(UserProtocolResponseTag.SESSION_AUTH_LEVEL);
                this.setAuthLevel(by);
                return encryptedResponse;
            }
            if (userErrorCodes == UserErrorCodes.FORCED_LOGOFF) {
                byte[] byArray;
                if (mainResponse.getEncryptedContent() == null || mainResponse.getEncryptedContent().length == 0) {
                    this.setAuthLevel(0);
                    return null;
                }
                try {
                    byArray = this.keyState.getVerifiedResponse(mainResponse.getEncryptedContent());
                }
                catch (DecryptFailedException decryptFailedException) {
                    this.setAuthLevel(0);
                    throw new SignerUserException(UserErrorCodes.DESERIALISATION_ERROR, this.sessionId);
                }
                EncryptedResponse encryptedResponse = new EncryptedResponse(this.sessionId, byArray);
                int n = encryptedResponse.getInt(UserProtocolResponseTag.RETURN_CODE);
                UserErrorCodes userErrorCodes3 = UserErrorCodes.valueOf(n);
                if (userErrorCodes3 != UserErrorCodes.OK) {
                    this.setAuthLevel(0);
                    throw new SignerUserException(userErrorCodes3, this.sessionId);
                }
                encryptedResponse.getByte(UserProtocolResponseTag.SESSION_AUTH_LEVEL);
                this.setAuthLevel(0);
                this.setAuthLevel(0);
                return encryptedResponse;
            }
            long l = this.sessionId;
            this.setAuthLevel(0);
            throw new SignerUserException(mainResponse.getUserErrorCode(), l);
        }
        this.setAuthLevel(0);
        throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, this.sessionId, "Response from the signer server was null", null);
    }

    public AuthLevel getCurrentAuthLevel() {
        if (!this.isConnected) {
            return AuthLevel.NONE;
        }
        if (this.keyState != null) {
            return this.currentAuthLevel;
        }
        return AuthLevel.NONE;
    }

    private void setAuthLevel(int n) {
        switch (n) {
            case 0: {
                this.clientSideLogoff();
                break;
            }
            case 1: {
                this.currentAuthLevel = AuthLevel.PASSWORD_ONLY;
                break;
            }
            case 2: {
                this.currentAuthLevel = AuthLevel.TWO_FACTOR;
                break;
            }
            default: {
                this.throwArgException("v", n + " is not a valid auth level");
            }
        }
    }

    public void connect() throws UnknownHostException, IOException, SignerUserException {
        if (this.url != null && this.url.length() != 0) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("SSLv3");
                sSLContext.init(null, new PermissiveTrustManager[]{new PermissiveTrustManager()}, null);
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
                URL uRL = new URL(this.url);
                this.httpsConnection = (HttpsURLConnection)uRL.openConnection();
                this.httpsConnection.setDoInput(true);
                this.httpsConnection.setDoOutput(true);
                this.httpsConnection.setRequestMethod("HEAD");
                this.doHttpsConnectWorkAround();
                this.httpsConnection.getResponseCode();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("No such SSL algorithm: " + noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                throw new IOException("Key management exception: " + keyManagementException);
            }
        } else {
            this.socket = new Socket(this.host, this.port);
        }
        this.isConnected = true;
    }

    public void disconnect() throws IOException {
        this.clientSideLogoff();
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.httpsConnection != null) {
            this.httpsConnection.disconnect();
        }
        this.isConnected = false;
    }

    public String getUserLoggedOn() {
        return this.userLoggedOn;
    }

    public LoginStatus logon(String string, String string2) throws UnknownHostException, IOException, SignerUserException, ClientSrp.SrpException {
        UserResponse userResponse;
        SRPResponse sRPResponse;
        if (string == null || "".equals(string)) {
            this.throwArgException("username", "cannot be null or empty");
        }
        if (string2 == null || "".equals(string2)) {
            this.throwArgException("password", "cannot be null or empty");
        }
        ClientSrp.SrpStep1Result srpStep1Result = this.srp.doClientSideSrp();
        if (!this.isConnected) {
            this.connect();
        }
        if ((sRPResponse = SRPResponse.fromUserResponse(userResponse = this.sendReceive(new SRPCommand(string, srpStep1Result.getBigA(), 1)))).getUserErrorCode() != UserErrorCodes.OK) {
            throw new SignerUserException(sRPResponse.getUserErrorCode(), sRPResponse.getSessionId());
        }
        this.authenticatorEnabled = sRPResponse.getAuthenticatorEnabled();
        byte[] byArray = null;
        try {
            switch (sRPResponse.getSrpType()) {
                case SHA1_USERNAME_PASSWORD: {
                    byArray = this.srp.create33PasswordHash(string, string2.toCharArray());
                    break;
                }
                case SHA256_PASSWORD: {
                    byArray = this.srp.createPasswordHash(string2.toCharArray());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, sRPResponse.getSessionId(), "Unsupported SRP protocol version: " + sRPResponse.getVersion(), null);
        }
        byte[] byArray2 = this.srp.getClientSideSecret(string, srpStep1Result.getLittleA(), srpStep1Result.getBigA(), sRPResponse.getB(), sRPResponse.getSalt(), byArray);
        this.keyState = new KeyStateHandler(byArray2);
        this.sessionId = sRPResponse.getSessionId();
        this.currentAuthLevel = AuthLevel.PASSWORD_ONLY;
        this.userLoggedOn = string;
        if (sRPResponse.getInitialPasswordState()) {
            return LoginStatus.LOGGED_IN_WITH_INITIAL_PASSWORD;
        }
        if (sRPResponse.getMustChangePassword()) {
            return LoginStatus.LOGGED_IN_MUST_CHANGE_PASSWORD;
        }
        return LoginStatus.LOGGED_IN_AND_READY;
    }

    private void clientSideLogoff() {
        this.sessionId = 0L;
        this.keyState = null;
        this.currentAuthLevel = AuthLevel.NONE;
    }

    public boolean isLoggedOn() {
        return this.sessionId != 0L && this.keyState != null;
    }

    public void logoff() {
        if (this.sessionId != 0L && this.isConnected && this.keyState != null) {
            try {
                EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.LOGOFF);
                this.sendReceiveEncryptedCommand(encryptedCommand);
            }
            catch (IOException iOException) {
            }
            catch (SignerUserException signerUserException) {
                // empty catch block
            }
        }
        this.clientSideLogoff();
    }

    public void activateAccount(String string) throws IOException, DecryptFailedException, SignerUserException {
        if (string == null) {
            this.throwArgException("newPassword", "cannot be null");
        }
        if (string.length() < 6) {
            this.throwArgException("newPassword", "password must be at least 6 characters");
        }
        byte[] byArray = this.srp.createPasswordHash(string.toCharArray());
        byte[] byArray2 = this.srp.createPasswordDerivedKey(string.toCharArray());
        EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.ACTIVATE_ACCOUNT).add(UserProtocolCommandTag.SHA256_PASSWORD_HASH, byArray).add(UserProtocolCommandTag.SHA256_PASSWORD_DERIVED_KEY, byArray2);
        this.sendReceiveEncryptedCommand(encryptedCommand);
    }

    public void noop() throws IOException, DecryptFailedException, SignerUserException {
        EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.NOOP);
        this.sendReceiveEncryptedCommand(encryptedCommand);
    }

    public void changePassword(String string, String string2) throws IOException, DecryptFailedException, SignerUserException {
        if (string == null || "".equals(string)) {
            this.throwArgException("oldPassword", "old password cannot be null or empty");
        }
        if (string2 == null) {
            this.throwArgException("newPassword", "cannot be null");
        }
        if (string2.length() < 6) {
            this.throwArgException("newPassword", "new password must be at least 6 characters");
        }
        byte[] byArray = this.srp.createPasswordHash(string.toCharArray());
        byte[] byArray2 = this.srp.createPasswordDerivedKey(string.toCharArray());
        byte[] byArray3 = this.srp.createPasswordDerivedKey(string2.toCharArray());
        byte[] byArray4 = this.srp.createPasswordHash(string2.toCharArray());
        EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.CHANGE_PASSWORD).add(UserProtocolCommandTag.SHA256_PASSWORD_HASH, byArray4).add(UserProtocolCommandTag.SHA256_PASSWORD_DERIVED_KEY, byArray3).add(UserProtocolCommandTag.PREVIOUS_SHA256_PASSWORD_HASH, byArray).add(UserProtocolCommandTag.PREVIOUS_SHA256_PASSWORD_DERIVED_KEY, byArray2);
        this.sendReceiveEncryptedCommand(encryptedCommand);
    }

    public byte[] exportKey(String string, long l) throws IOException, DecryptFailedException, SignerUserException {
        EncryptedCommand encryptedCommand;
        EncryptedResponse encryptedResponse;
        if (string == null) {
            this.throwArgException("containerPassword", "cannot be null");
        }
        if (string.length() < 6) {
            this.throwArgException("containerPassword", "password must be at least 6 characters");
        }
        if (l <= 0L) {
            this.throwArgException("keyid", "key id must be positive");
        }
        if ((encryptedResponse = this.sendReceiveEncryptedCommand(encryptedCommand = new EncryptedCommand(UserCommandType.EXPORT_KEY).add(UserProtocolCommandTag.KEY_ID, l).add(UserProtocolCommandTag.EXPORT_KEY_FILE_PASSWORD, string))) != null) {
            return encryptedResponse.getBytes(UserProtocolResponseTag.EXPORTED_KEY);
        }
        return null;
    }

    private byte[] doOperation(KeyEntry keyEntry, boolean bl, String string, byte[] byArray) throws IOException, DecryptFailedException, SignerUserException {
        EncryptedResponse encryptedResponse;
        if (keyEntry == null) {
            this.throwArgException("keyPair", "cannot be null");
        }
        if (byArray == null) {
            this.throwArgException("data", "cannot be null");
        }
        BlindSignatures blindSignatures = new BlindSignatures(keyEntry.publicKey);
        BlindSignatures.BlindSignatureData blindSignatureData = blindSignatures.blindData(byArray);
        EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.DO_OPERATION).add(UserProtocolCommandTag.KEY_ID, keyEntry.keyId).add(UserProtocolCommandTag.IS_SIGNATURE, bl).add(UserProtocolCommandTag.SIGNATURE_DATA, blindSignatureData.getData());
        if (string != null && string.length() > 0) {
            encryptedCommand.add(UserProtocolCommandTag.SHA256_PASSWORD_DERIVED_KEY, this.srp.createPasswordDerivedKey(string.toCharArray()));
        }
        if ((encryptedResponse = this.sendReceiveEncryptedCommand(encryptedCommand)) == null) {
            throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, this.sessionId, "Failed to receive encrypted response from server", null);
        }
        byte[] byArray2 = encryptedResponse.getBytes(UserProtocolResponseTag.SIGNATURE);
        return blindSignatures.unblindSignature(byArray2, blindSignatureData.getUnblindData());
    }

    public byte[] sign(KeyEntry keyEntry, String string, SignerSignature signerSignature) throws IOException, DecryptFailedException, SignerUserException {
        if (signerSignature == null) {
            this.throwArgException("toBeSigned", "cannot be null");
        }
        byte[] byArray = signerSignature.getEncodedSignatureData(keyEntry);
        return this.doOperation(keyEntry, true, string, byArray);
    }

    public byte[] decrypt(KeyEntry keyEntry, String string, SignerDecryption signerDecryption) throws SignerUserException, IOException, DecryptFailedException {
        if (signerDecryption == null) {
            this.throwArgException("toBeDecrypted", "cannot be null");
        }
        byte[] byArray = this.doOperation(keyEntry, false, string, signerDecryption.getEncryption());
        try {
            return signerDecryption.processDecryptedData(byArray);
        }
        catch (SignerDecryption.ParsingFailedException parsingFailedException) {
            throw new SignerUserException(UserErrorCodes.DESERIALISATION_ERROR, this.sessionId, "Failed to parse the encoding inside the encryption", parsingFailedException);
        }
    }

    public List<PolicyEntry> getPolicies() throws IOException, DecryptFailedException, SignerUserException {
        EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.GET_KEYS);
        EncryptedResponse encryptedResponse = this.sendReceiveEncryptedCommand(encryptedCommand);
        if (encryptedResponse != null) {
            return encryptedResponse.getPolicyList(UserProtocolResponseTag.POLICY_LIST);
        }
        return Collections.emptyList();
    }

    public List<KeyEntry> getKeys() throws IOException, DecryptFailedException, SignerUserException {
        List<PolicyEntry> list = this.getPolicies();
        ArrayList<KeyEntry> arrayList = new ArrayList<KeyEntry>();
        for (PolicyEntry policyEntry : list) {
            arrayList.addAll(policyEntry.keys);
        }
        return arrayList;
    }

    public List<PolicyEntry> getPoliciesAnonymous(String string) throws IOException, SignerUserException {
        AnonCommand anonCommand;
        AnonResponse anonResponse;
        if (string == null || string.equals("")) {
            this.throwArgException("username", "cannot be null or empty");
        }
        if ((anonResponse = this.sendReceiveAnon(anonCommand = new AnonCommand(AnonCommandType.GET_KEYS, 1, string))) != null) {
            return anonResponse.getPolicyEntries();
        }
        return Collections.emptyList();
    }

    public boolean isAuthenticatorEnabled() {
        return this.authenticatorEnabled;
    }

    public List<AuthenticationToken> getTokens() throws IOException, SignerUserException {
        if (!this.authenticatorEnabled) {
            throw new SignerUserException(UserErrorCodes.AUTHENTICATOR_DISABLED, this.sessionId, "Authenticator is disabled", null);
        }
        EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.LIST_TOKENS);
        EncryptedResponse encryptedResponse = this.sendReceiveEncryptedCommand(encryptedCommand);
        if (encryptedResponse == null) {
            return Collections.emptyList();
        }
        String string = encryptedResponse.getString(UserProtocolResponseTag.TOKEN_TYPES_LIST);
        String string2 = encryptedResponse.getString(UserProtocolResponseTag.TOKEN_SERIAL_LIST);
        List<AuthenticationToken> list = AuthenticationToken.getList(string, string2);
        return list;
    }

    public void ping() throws IOException, SignerUserException {
        AnonCommand anonCommand = new AnonCommand(AnonCommandType.PING, 1);
        this.sendReceiveAnon(anonCommand);
    }

    public AuthenticationChallenge getChallenge(AuthenticationToken authenticationToken) throws IOException, SignerUserException {
        EncryptedCommand encryptedCommand;
        EncryptedResponse encryptedResponse;
        if (!this.authenticatorEnabled) {
            throw new SignerUserException(UserErrorCodes.AUTHENTICATOR_DISABLED, this.sessionId, "Authenticator is disabled", null);
        }
        if (authenticationToken == null || authenticationToken.getTokenSerial() == null || authenticationToken.getTokenSerial().equals("")) {
            this.throwArgException("token", "cannot be null or have empty serial");
        }
        if ((encryptedResponse = this.sendReceiveEncryptedCommand(encryptedCommand = new EncryptedCommand(UserCommandType.GET_CHALLENGE).add(UserProtocolCommandTag.TOKEN_TYPE, authenticationToken.getTokenType()).add(UserProtocolCommandTag.TOKEN_SERIAL, authenticationToken.getTokenSerial()))) == null) {
            throw new SignerUserException(UserErrorCodes.GENERAL_ERROR, this.sessionId);
        }
        String string = encryptedResponse.getString(UserProtocolResponseTag.AUTHENTICATION_CHALLENGE_ID);
        return new AuthenticationSMSChallenge(string);
    }

    public void escalate(String string, AuthenticationToken authenticationToken) throws IOException, SignerUserException, GeneralSecurityException {
        if (!this.authenticatorEnabled) {
            throw new SignerUserException(UserErrorCodes.AUTHENTICATOR_DISABLED, this.sessionId, "Authenticator is disabled", null);
        }
        if (string == null) {
            this.throwArgException("otp", "cannot be null");
        }
        if (authenticationToken == null || authenticationToken.getTokenSerial() == null || authenticationToken.getTokenSerial().equals("")) {
            this.throwArgException("token", "cannot be null or have empty serial");
        }
        String string2 = authenticationToken.getTokenType();
        byte[] byArray = AuthenticatorUtils.getSalt(32);
        byte[] byArray2 = null;
        byte[] byArray3 = AuthenticatorUtils.getKeyMaterial(string, byArray);
        if (string2.equals("OATH-TOTP") || string2.equals("OATH-HOTP")) {
            byArray2 = AuthenticatorUtils.getEncryptedOtpAndSalt(string, byArray, this.ctk);
        } else if (string2.equals("Vasco-OTP-Time") || string2.equals("SMS")) {
            byArray2 = AuthenticatorUtils.getOtpAndSalt(string, byArray);
        } else {
            throw new RuntimeException("Illegal token type: " + string2);
        }
        EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.ESCALATE).add(UserProtocolCommandTag.TOKEN_TYPE, authenticationToken.getTokenType()).add(UserProtocolCommandTag.TOKEN_SERIAL, authenticationToken.getTokenSerial()).add(UserProtocolCommandTag.AUTHENTICATOR_CTK_ID, this.ctkId).add(UserProtocolCommandTag.TOKEN_CREDENTIALS, byArray2);
        this.sendReceiveEncryptedCommand(encryptedCommand);
        if (this.getCurrentAuthLevel() == AuthLevel.TWO_FACTOR) {
            this.keyState.updateSrpSecret(byArray3);
        }
    }

    public void setCertificate(KeyEntry keyEntry, byte[] byArray, String string) throws IOException, DecryptFailedException, SignerUserException {
        EncryptedCommand encryptedCommand;
        EncryptedResponse encryptedResponse;
        if (keyEntry == null) {
            this.throwArgException("keyPair", "cannot be null");
        }
        if (byArray == null) {
            this.throwArgException("certificate", "cannot be null");
        }
        if (string == null) {
            this.throwArgException("displayText", "cannot be null");
        }
        if ((encryptedResponse = this.sendReceiveEncryptedCommand(encryptedCommand = new EncryptedCommand(UserCommandType.SET_CERTIFICATE).add(UserProtocolCommandTag.KEY_ID, keyEntry.keyId).add(UserProtocolCommandTag.CERTIFICATE, byArray).add(UserProtocolCommandTag.CERTIFICATE_DISPLAY_TEXT, string))) == null) {
            throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, this.sessionId, "Failed to receive encrypted response from server", null);
        }
    }

    public void createNewKey(PolicyEntry policyEntry, String string) throws IOException, DecryptFailedException, SignerUserException {
        EncryptedResponse encryptedResponse;
        if (policyEntry == null) {
            this.throwArgException("policyEntry", "cannot be null");
        }
        EncryptedCommand encryptedCommand = new EncryptedCommand(UserCommandType.CREATE_NEW_KEY).add(UserProtocolCommandTag.POLICY_ID, policyEntry.id);
        if (string != null && string.length() > 0) {
            encryptedCommand.add(UserProtocolCommandTag.SHA256_PASSWORD_DERIVED_KEY, this.srp.createPasswordDerivedKey(string.toCharArray()));
        }
        if ((encryptedResponse = this.sendReceiveEncryptedCommand(encryptedCommand)) == null) {
            throw new SignerUserException(UserErrorCodes.COMMUNICATION_ERROR, this.sessionId, "Failed to receive encrypted response from server", null);
        }
    }

    private static class PermissiveTrustManager
    implements X509TrustManager {
        private PermissiveTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthLevel {
        NONE,
        PASSWORD_ONLY,
        TWO_FACTOR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoginStatus {
        LOGGED_IN_AND_READY,
        LOGGED_IN_WITH_INITIAL_PASSWORD,
        LOGGED_IN_MUST_CHANGE_PASSWORD;

    }
}

