/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.sdk.user;

import com.cryptomathic.common.utils.Hex;
import com.cryptomathic.signer.api.user.KeyEntry;
import com.cryptomathic.signer.sdk.user.IncrementalSignerSignature;
import com.cryptomathic.signer.sdk.user.SignerSignature;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class SignatureFactory {
    private static final byte[] SHA1_OID_HEADER = Hex.decode("3021300906052b0e03021a05000414");
    private static final byte[] SHA256_OID_HEADER = Hex.decode("3031300d060960864801650304020105000420");
    private static final byte[] SHA384_OID_HEADER = Hex.decode("3041300d060960864801650304020205000430");
    private static final byte[] SHA512_OID_HEADER = Hex.decode("3051300d060960864801650304020305000440");
    private static final byte[] MD5_OID_HEADER = Hex.decode("3020300c06082a864886f70d020505000410");

    private static byte[] pkcs1EncodeHash(byte[] byArray, KeyEntry keyEntry, byte[] byArray2) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyEntry.publicKey);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            int n = (rSAPublicKey.getModulus().bitLength() + 7) / 8;
            if (byArray2.length + byArray.length + 11 > n) {
                throw new IllegalArgumentException("keyPair to small to encode the hash");
            }
            byte[] byArray3 = new byte[n];
            byArray3[0] = 0;
            byArray3[1] = 1;
            int n2 = 2;
            while (n2 < n - byArray2.length - byArray.length - 1) {
                byArray3[n2++] = -1;
            }
            byArray3[n2++] = 0;
            System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, n2 += byArray.length, byArray2.length);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("RSA not found in system");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalArgumentException("keyPair does not contain a legal public RSA key");
        }
    }

    public static IncrementalSignerSignature getPkcs1Sha1Signature() throws NoSuchAlgorithmException {
        return new IncrementalPkcs1HashSignature(SHA1_OID_HEADER, "SHA-1");
    }

    public static SignerSignature getPkcs1Sha1SignatureWithHash(byte[] byArray) {
        if (byArray == null || byArray.length != 20) {
            throw new IllegalArgumentException("Illegal SHA-1 hash value. Must be 20 bytes");
        }
        return new Pkcs1HashSignature(SHA1_OID_HEADER, byArray);
    }

    public static IncrementalSignerSignature getPkcs1Sha256Signature() throws NoSuchAlgorithmException {
        return new IncrementalPkcs1HashSignature(SHA256_OID_HEADER, "SHA-256");
    }

    public static SignerSignature getPkcs1Sha256SignatureWithHash(byte[] byArray) {
        if (byArray == null || byArray.length != 32) {
            throw new IllegalArgumentException("Illegal SHA-256 hash value. Must be 32 bytes");
        }
        return new Pkcs1HashSignature(SHA256_OID_HEADER, byArray);
    }

    public static IncrementalSignerSignature getPkcs1Sha384Signature() throws NoSuchAlgorithmException {
        return new IncrementalPkcs1HashSignature(SHA384_OID_HEADER, "SHA-384");
    }

    public static SignerSignature getPkcs1Sha384SignatureWithHash(byte[] byArray) {
        if (byArray == null || byArray.length != 48) {
            throw new IllegalArgumentException("Illegal SHA-384 hash value. Must be 48 bytes");
        }
        return new Pkcs1HashSignature(SHA384_OID_HEADER, byArray);
    }

    public static IncrementalSignerSignature getPkcs1Sha512Signature() throws NoSuchAlgorithmException {
        return new IncrementalPkcs1HashSignature(SHA512_OID_HEADER, "SHA-512");
    }

    public static SignerSignature getPkcs1Sha512SignatureWithHash(byte[] byArray) {
        if (byArray == null || byArray.length != 64) {
            throw new IllegalArgumentException("Illegal SHA-512 hash value. Must be 64 bytes");
        }
        return new Pkcs1HashSignature(SHA512_OID_HEADER, byArray);
    }

    public static IncrementalSignerSignature getPkcs1Md5Signature() throws NoSuchAlgorithmException {
        return new IncrementalPkcs1HashSignature(MD5_OID_HEADER, "MD5");
    }

    public static SignerSignature getPkcs1Md5SignatureWithHash(byte[] byArray) {
        if (byArray == null || byArray.length != 16) {
            throw new IllegalArgumentException("Illegal MD-5 hash value. Must be 16 bytes");
        }
        return new Pkcs1HashSignature(MD5_OID_HEADER, byArray);
    }

    public static SignerSignature getRawSignature(final byte[] byArray) {
        return new SignerSignature(){

            public byte[] getEncodedSignatureData(KeyEntry keyEntry) {
                return byArray;
            }
        };
    }

    private static class IncrementalPkcs1HashSignature
    implements IncrementalSignerSignature {
        private final byte[] oidHeader;
        private boolean complete = false;
        private byte[] hash;
        private MessageDigest digest;

        IncrementalPkcs1HashSignature(byte[] byArray, String string) throws NoSuchAlgorithmException {
            this.oidHeader = byArray;
            this.complete = false;
            this.hash = null;
            this.digest = MessageDigest.getInstance(string);
        }

        public byte[] getEncodedSignatureData(KeyEntry keyEntry) {
            if (!this.complete) {
                throw new IllegalStateException("Can only create signature on completed signature objects");
            }
            return SignatureFactory.pkcs1EncodeHash(this.oidHeader, keyEntry, this.hash);
        }

        public void update(byte by) {
            if (this.complete) {
                throw new IllegalStateException("Cannot update completed signature objects");
            }
            this.digest.update(by);
        }

        public void update(byte[] byArray) {
            this.update(byArray, 0, byArray.length);
        }

        public void update(byte[] byArray, int n, int n2) {
            if (this.complete) {
                throw new IllegalStateException("Cannot update completed signature objects");
            }
            this.digest.update(byArray, n, n2);
        }

        public void complete() {
            this.hash = this.digest.digest();
            this.complete = true;
            this.digest = null;
        }
    }

    private static class Pkcs1HashSignature
    implements SignerSignature {
        private final byte[] oidHeader;
        private final byte[] hash;

        Pkcs1HashSignature(byte[] byArray, byte[] byArray2) {
            this.oidHeader = byArray;
            this.hash = byArray2;
        }

        public byte[] getEncodedSignatureData(KeyEntry keyEntry) {
            return SignatureFactory.pkcs1EncodeHash(this.oidHeader, keyEntry, this.hash);
        }
    }
}

