/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.common.utils;

import com.cryptomathic.signer.common.utils.PlatformHelper;
import java.io.File;
import java.io.FileNotFoundException;

public class SignerDataFolder {
    private static String getUserDataFolder() throws FileNotFoundException {
        String string = System.getenv("APPDATA");
        if (string == null) {
            throw new FileNotFoundException("User application data folder not found in environment variable 'APPDATA'");
        }
        return string;
    }

    private static String getProgramDataFolder() throws FileNotFoundException {
        String string = System.getenv("ALLUSERSPROFILE");
        if (string == null) {
            throw new FileNotFoundException("Program data folder not found in environment variable 'ALLUSERSPROFILE'");
        }
        return string;
    }

    private static String getCryptomathicUserDataFolder() throws FileNotFoundException {
        File file = new File(SignerDataFolder.getUserDataFolder(), "Cryptomathic");
        if (!file.exists() && !file.mkdir()) {
            throw new FileNotFoundException("Cryptomathic user application data folder not found and cannot be created: " + file);
        }
        return file.getPath();
    }

    private static String getCryptomathicProgramDataFolder() throws FileNotFoundException {
        File file = new File(SignerDataFolder.getProgramDataFolder(), "Cryptomathic");
        if (!file.exists() && !file.mkdir()) {
            throw new FileNotFoundException("Cryptomathic program data folder not found and cannot be created: " + file);
        }
        return file.getPath();
    }

    public static String getSignerUserDataFolder() throws FileNotFoundException {
        if (PlatformHelper.isWindows()) {
            File file = new File(SignerDataFolder.getCryptomathicUserDataFolder(), "Signer");
            if (!file.exists() && !file.mkdir()) {
                throw new FileNotFoundException("Cryptomathic Signer user application data folder not found and cannot be created: " + file);
            }
            return file.getPath();
        }
        return ".";
    }

    public static String getSignerProgramDataFolder() throws FileNotFoundException {
        if (PlatformHelper.isWindows()) {
            File file = new File(SignerDataFolder.getCryptomathicProgramDataFolder(), "Signer");
            if (!file.exists() && !file.mkdir()) {
                throw new FileNotFoundException("Cryptomathic Signer program data folder not found and cannot be created: " + file);
            }
            return file.getPath();
        }
        return ".";
    }
}

