/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.protocol;

import com.cryptomathic.signer.api.user.message.UserCommand;
import com.cryptomathic.signer.api.user.message.UserProtocolType;
import com.cryptomathic.signer.api.user.message.UserResponse;
import com.cryptomathic.signer.api.user.message.UserResponseType;
import com.cryptomathic.signer.common.exceptions.SignerException;
import com.cryptomathic.signer.common.protocol.Command;
import com.cryptomathic.signer.common.protocol.Protocol;
import com.cryptomathic.signer.common.protocol.Response;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UserProtocol
implements Protocol {
    public void serializeCommand(OutputStream outputStream, Command command) throws IOException, SignerException {
        if (command instanceof UserCommand) {
            UserCommand userCommand = (UserCommand)command;
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeBytes(userCommand.getCommandType().getHeader());
            byte[] byArray = userCommand.toByteArray();
            dataOutputStream.writeInt(byArray.length + 16);
            dataOutputStream.write(new byte[16]);
            dataOutputStream.write(byArray);
        }
    }

    public Command deserializeCommand(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "ASCII");
        UserProtocolType userProtocolType = UserProtocolType.valueOfHeader(string);
        if (userProtocolType == null) {
            throw new IOException("User command protocol magic (" + string + ") is unknown");
        }
        int n = dataInputStream.readInt();
        if (n < 16) {
            throw new IOException("Length cannot be negative");
        }
        byte[] byArray2 = new byte[n - 16];
        byte[] byArray3 = new byte[16];
        dataInputStream.readFully(byArray3);
        dataInputStream.readFully(byArray2);
        UserCommand userCommand = new UserCommand(userProtocolType, byArray2, byArray3);
        return userCommand;
    }

    public void serializeResponse(OutputStream outputStream, Response response) throws IOException, SignerException {
        if (response instanceof UserResponse) {
            UserResponse userResponse = (UserResponse)response;
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeBytes(userResponse.getResponseType().getHeader());
            byte[] byArray = userResponse.toByteArray();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    public Response deserializeResponse(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "ASCII");
        UserResponseType userResponseType = UserResponseType.valueOfHeader(string);
        if (userResponseType == null) {
            throw new IOException("User response protocol magic (" + string + ") is unknown");
        }
        int n = dataInputStream.readInt();
        if (n < 0) {
            throw new IOException("Length cannot be negative");
        }
        byte[] byArray2 = new byte[n];
        dataInputStream.readFully(byArray2);
        UserResponse userResponse = new UserResponse(userResponseType, byArray2);
        return userResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCompleteCommand(InputStream inputStream) throws IOException {
        inputStream.mark(8);
        try {
            int n = inputStream.available();
            if (n < 8) {
                boolean bl = false;
                return bl;
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            boolean bl = 8 + n2 <= n;
            return bl;
        }
        finally {
            inputStream.reset();
        }
    }
}

