/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.message;

import com.cryptomathic.signer.api.user.message.UserProtocolType;
import com.cryptomathic.signer.common.protocol.Command;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class UserCommand
implements Command {
    private String clientAddress = null;
    private byte[] payload;
    private UserProtocolType commandType;

    public UserCommand() {
    }

    public UserCommand(UserProtocolType userProtocolType, byte[] byArray) {
        this.payload = byArray;
        this.commandType = userProtocolType;
    }

    public UserCommand(UserProtocolType userProtocolType, byte[] byArray, byte[] byArray2) {
        this.payload = byArray;
        this.commandType = userProtocolType;
        if (Arrays.equals(byArray2, new byte[16])) {
            this.clientAddress = null;
            return;
        }
        try {
            byte[] byArray3 = new byte[4];
            System.arraycopy(byArray2, 0, byArray3, 0, 4);
            InetAddress inetAddress = InetAddress.getByAddress(byArray3);
            this.clientAddress = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.clientAddress = "1.2.3.4";
        }
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(String string) {
        if (this.clientAddress == null) {
            this.clientAddress = string;
        }
    }

    public void setTypeAndPayload(UserProtocolType userProtocolType, byte[] byArray) {
        this.commandType = userProtocolType;
        this.payload = byArray;
    }

    public UserProtocolType getCommandType() {
        return this.commandType;
    }

    public byte[] toByteArray() throws UnsupportedEncodingException, IOException {
        return this.payload;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray, 0, n);
        return new String(byArray, "UTF-8");
    }

    static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeInt(0);
        } else {
            byte[] byArray = string.getBytes("UTF-8");
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    static byte[] readByteArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray, 0, n);
        return byArray;
    }

    static void writeByteArray(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        if (byArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
    }
}

