/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.message;

import com.cryptomathic.signer.api.common.types.SrpType;
import com.cryptomathic.signer.api.user.errors.UserErrorCodes;
import com.cryptomathic.signer.api.user.message.UserCommand;
import com.cryptomathic.signer.api.user.message.UserResponse;
import com.cryptomathic.signer.api.user.message.UserResponseType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SRPResponse
extends UserResponse {
    private int version = 1;
    private byte[] B = new byte[0];
    private byte[] salt = new byte[0];
    private long sessionId = 0L;
    private int passwordState = 0;
    private int errorCode = 0;
    private boolean authenticatorEnabled;
    private static final int HAS_INITIAL_PASSWORD = 1;
    private static final int MUST_CHANGE_PASSWORD = 2;

    public SRPResponse() {
        super(UserResponseType.SRP, null);
    }

    public SRPResponse(UserErrorCodes userErrorCodes) {
        this();
        this.errorCode = userErrorCodes.getErrorCode();
    }

    public SRPResponse(long l, byte[] byArray, byte[] byArray2, boolean bl, boolean bl2, int n, boolean bl3) {
        this();
        this.B = byArray;
        this.sessionId = l;
        this.salt = byArray2;
        this.setInitialPasswordState(bl);
        this.setMustChangePassword(bl2);
        this.version = n;
        this.errorCode = 0;
        this.authenticatorEnabled = bl3;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public SrpType getSrpType() {
        return SrpType.fromVersionValue(this.version);
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public byte[] getB() {
        return this.B;
    }

    public void setB(byte[] byArray) {
        this.B = byArray;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] byArray) {
        this.salt = byArray;
    }

    public UserErrorCodes getUserErrorCode() {
        return UserErrorCodes.valueOf(this.errorCode);
    }

    public void setUserErrorCode(UserErrorCodes userErrorCodes) {
        this.errorCode = userErrorCodes.getErrorCode();
    }

    public boolean getInitialPasswordState() {
        return (this.passwordState & 1) != 0;
    }

    public void setInitialPasswordState(boolean bl) {
        this.passwordState &= 0xFFFFFFFE;
        this.passwordState |= bl ? 1 : 0;
    }

    public boolean getMustChangePassword() {
        return (this.passwordState & 2) != 0;
    }

    public void setMustChangePassword(boolean bl) {
        this.passwordState &= 0xFFFFFFFD;
        this.passwordState |= bl ? 2 : 0;
    }

    public boolean getAuthenticatorEnabled() {
        return this.authenticatorEnabled;
    }

    public static SRPResponse fromUserResponse(UserResponse userResponse) throws IOException {
        SRPResponse sRPResponse = new SRPResponse();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(userResponse.getPayload()));
        sRPResponse.setTypeAndPayload(userResponse.getResponseType(), userResponse.getPayload());
        sRPResponse.version = dataInputStream.readInt();
        sRPResponse.sessionId = dataInputStream.readLong();
        sRPResponse.B = UserCommand.readByteArray(dataInputStream);
        sRPResponse.salt = UserCommand.readByteArray(dataInputStream);
        sRPResponse.passwordState = dataInputStream.readInt();
        sRPResponse.errorCode = dataInputStream.readInt();
        sRPResponse.authenticatorEnabled = dataInputStream.readInt() != 0;
        return sRPResponse;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeLong(this.sessionId);
        UserCommand.writeByteArray(dataOutputStream, this.B);
        UserCommand.writeByteArray(dataOutputStream, this.salt);
        dataOutputStream.writeInt(this.passwordState);
        dataOutputStream.writeInt(this.errorCode);
        dataOutputStream.writeInt(this.authenticatorEnabled ? 1 : 0);
        return byteArrayOutputStream.toByteArray();
    }
}

