/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.message;

import com.cryptomathic.signer.api.user.message.UserCommand;
import com.cryptomathic.signer.api.user.message.UserProtocolType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SRPCommand
extends UserCommand {
    private String username;
    private byte[] A;
    private int version;

    public SRPCommand() {
        super(UserProtocolType.SRP, null);
    }

    public SRPCommand(String string, byte[] byArray, int n) {
        super(UserProtocolType.SRP, null);
        this.username = string;
        this.A = byArray;
        this.version = n;
    }

    public int getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getA() {
        return this.A;
    }

    public static SRPCommand fromUserCommand(UserCommand userCommand) throws IOException {
        SRPCommand sRPCommand = new SRPCommand();
        sRPCommand.setClientAddress(userCommand.getClientAddress());
        sRPCommand.setTypeAndPayload(userCommand.getCommandType(), userCommand.getPayload());
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(userCommand.getPayload()));
        sRPCommand.version = dataInputStream.readInt();
        sRPCommand.username = UserCommand.readString(dataInputStream);
        sRPCommand.A = UserCommand.readByteArray(dataInputStream);
        return sRPCommand;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.version);
        UserCommand.writeString(dataOutputStream, this.username);
        UserCommand.writeByteArray(dataOutputStream, this.A);
        return byteArrayOutputStream.toByteArray();
    }
}

