/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.message;

import com.cryptomathic.signer.api.user.errors.UserErrorCodes;
import com.cryptomathic.signer.api.user.message.UserCommand;
import com.cryptomathic.signer.api.user.message.UserResponse;
import com.cryptomathic.signer.api.user.message.UserResponseType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MainResponse
extends UserResponse {
    public static final int VERSION_CURRENT = 1;
    private int version = 1;
    private int errorCode = 0;
    private byte[] encryptedContent;

    public MainResponse() {
        super(UserResponseType.ENCRYPTED, null);
    }

    public MainResponse(UserErrorCodes userErrorCodes) {
        this();
        this.errorCode = userErrorCodes.getErrorCode();
    }

    public MainResponse(byte[] byArray, int n) {
        this();
        this.errorCode = 0;
        this.version = n;
        this.encryptedContent = byArray;
    }

    public byte[] getEncryptedContent() {
        return this.encryptedContent;
    }

    public int getVersion() {
        return this.version;
    }

    public UserErrorCodes getUserErrorCode() {
        return UserErrorCodes.valueOf(this.errorCode);
    }

    public void setUserErrorCode(UserErrorCodes userErrorCodes) {
        this.errorCode = userErrorCodes.getErrorCode();
    }

    public static MainResponse fromUserResponse(UserResponse userResponse) throws IOException {
        MainResponse mainResponse = new MainResponse();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(userResponse.getPayload()));
        if (userResponse.getResponseType() != UserResponseType.ENCRYPTED) {
            throw new IOException("Expected a MainResponse here");
        }
        mainResponse.setTypeAndPayload(userResponse.getResponseType(), userResponse.getPayload());
        mainResponse.version = dataInputStream.readInt();
        mainResponse.encryptedContent = UserCommand.readByteArray(dataInputStream);
        mainResponse.errorCode = dataInputStream.readInt();
        return mainResponse;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.version);
        UserCommand.writeByteArray(dataOutputStream, this.encryptedContent);
        dataOutputStream.writeInt(this.errorCode);
        return byteArrayOutputStream.toByteArray();
    }
}

