/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.user.errors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UserErrorCodes {
    OK(0, "All is well"),
    COMMAND_FAILED_ON_SERVER(17, "Command failed on server"),
    UNEXPECTED_COMMAND_PARAMETER(33, "Unexpected command parameters"),
    MALFORMED_COMMAND_PARAMETER(34, "Malformed command parameters"),
    COMMAND_DISABLED(35, "Command disabled"),
    INSUFFICIENT_PRIVILEGES(36, "Insufficient privileges"),
    USER_DISABLED(37, "User account is permanently disabled"),
    KEY_DISABLED(38, "Key is disabled"),
    USER_PASSWORD_RESET_BY_ADMINISTRATOR(39, "The password has been reset by the adminstrator so the session is unavailable"),
    AUTHENTICATION_FAILED_TRY_AGAIN(40, "Authentication failed, please try again"),
    AUTHENTICATION_FAILED_FORCED_LOGOFF(41, "Authentication has failed too many times so the user was forced to log off"),
    USER_SUSPENDED(48, "User account is temporarily suspended"),
    USER_MUST_CHANGE_PASSWORD(49, "User must change password"),
    USER_MUST_ACTIVATE_ACCOUNT(50, "User has an initial password and must activate the account"),
    USER_IS_ENABLED(51, "The user is already enabled"),
    PRIVILEGE_NOT_FOUND(52, "The privilege for the user was not found"),
    KEY_ALREADY_HAS_CERTIFICATE(53, "A certificate has already been assigned to the key"),
    CERTIFICATE_DOES_NOT_MATCH_KEY(54, "The certificate does not match the key"),
    GENERAL_ERROR(1000, "An unknown error happened"),
    FORCED_LOGOFF(1001, "The command policy forced user log off"),
    COMMUNICATION_ERROR(1002, "Communication error"),
    NOT_LOGGED_IN(1003, "Not logged in"),
    DESERIALISATION_ERROR(1004, "Protocol deserialisation error"),
    INTERMITTENT_SERVER_ERROR_TRY_AGAIN(1005, "Intermittent server error, please try again"),
    AUTHENTICATOR_DISABLED(1006, "Authenticator is disabled, functionality unavailabled");

    private int code;
    private String description;

    private UserErrorCodes(int n2, String string2) {
        this.code = n2;
        this.description = string2;
    }

    public int getErrorCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static UserErrorCodes valueOf(int n) {
        for (UserErrorCodes userErrorCodes : UserErrorCodes.values()) {
            if (n != userErrorCodes.getErrorCode()) continue;
            return userErrorCodes;
        }
        throw new IllegalArgumentException("No such error code in UserErrorCodes");
    }
}

