/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.zones;

import com.cryptomathic.signer.api.common.zones.ZoneItem;
import com.cryptomathic.signer.api.common.zones.ZoneItemType;
import com.cryptomathic.signer.common.exceptions.ZoneItemParseException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneItems {
    private List<ZoneItem> zoneItems;

    public ZoneItems(List<ZoneItem> arrayList) {
        this.zoneItems = arrayList != null ? arrayList : new ArrayList();
    }

    public ZoneItems(String string) throws ZoneItemParseException {
        this.zoneItems = ZoneItems.parseZoneItems(string);
    }

    public List<ZoneItem> getZoneItems() {
        return this.zoneItems;
    }

    public String getZoneItemsRaw() {
        return this.formatZoneItems(this.zoneItems);
    }

    public void clearZoneItems() {
        this.zoneItems.clear();
    }

    public void addZoneItem(String string) throws ZoneItemParseException {
        ZoneItem zoneItem = ZoneItemType.parseIntoInstance(string);
        this.zoneItems.add(zoneItem);
    }

    private static List<ZoneItem> parseZoneItems(String string) throws ZoneItemParseException {
        String[] stringArray;
        ArrayList<ZoneItem> arrayList = new ArrayList<ZoneItem>();
        if (string == null) {
            return arrayList;
        }
        for (String string2 : stringArray = string.split(",")) {
            if (string2.trim().equals("")) continue;
            ZoneItem zoneItem = ZoneItemType.parseIntoInstance(string2);
            arrayList.add(zoneItem);
        }
        return arrayList;
    }

    private String formatZoneItems(List<ZoneItem> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ZoneItem zoneItem : list) {
            stringBuffer.append(", ");
            stringBuffer.append(zoneItem.toString());
        }
        String string = stringBuffer.toString();
        return string.startsWith(", ") ? string.substring(2) : string;
    }
}

