/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.zones;

import com.cryptomathic.signer.api.common.zones.ZoneItem;
import com.cryptomathic.signer.common.exceptions.ZoneItemParseException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPv6AddressMask
implements ZoneItem {
    private int mask;
    private Inet6Address ip;
    private long ipHigh;
    private long ipLow;

    public static boolean looksParsable(String string) {
        boolean bl = string.matches("([\\:\\.\\dabcdefABCDEF]+)(/\\d+)?");
        boolean bl2 = string.matches(".*:.*:.*");
        return bl && bl2;
    }

    public IPv6AddressMask(String string) throws ZoneItemParseException {
        Object object;
        String[] stringArray = string.split("/");
        if (stringArray.length > 2) {
            throw new ZoneItemParseException("This does not look like an IPv6 address mask (too many separators): " + string);
        }
        String string2 = stringArray[0];
        String string3 = stringArray.length < 2 ? "128" : stringArray[1];
        try {
            object = InetAddress.getByName(string2);
            if (!(object instanceof Inet6Address)) {
                throw new ZoneItemParseException("The IPv6 address looks more like an IPv4 address");
            }
            this.ip = (Inet6Address)object;
        }
        catch (UnknownHostException unknownHostException) {
            throw new ZoneItemParseException("The IPv6 address is wrong");
        }
        object = this.ip.getAddress();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
        try {
            this.ipHigh = dataInputStream.readLong();
            this.ipLow = dataInputStream.readLong();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (string3.trim().length() == 0) {
                throw new ZoneItemParseException("The IPv6 mask must not be an empty string");
            }
            this.mask = Integer.parseInt(string3.trim());
            if (this.mask < 0 || this.mask > 128) {
                throw new ZoneItemParseException("The IP mask should be between 0 and 128 (both inclusive): " + this.mask);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ZoneItemParseException("This does not look like an IPv6 mask (bad value): " + string3);
        }
    }

    public String toString() {
        String string = this.mask != 128 ? "/" + this.mask : "";
        return this.ip.getHostAddress() + string;
    }

    public boolean isAccessible() {
        return true;
    }

    public boolean doesInclude(InetAddress inetAddress) {
        long l = 0L;
        long l2 = 0L;
        if (!(inetAddress instanceof Inet6Address)) {
            return false;
        }
        byte[] byArray = inetAddress.getAddress();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            l = dataInputStream.readLong();
            l2 = dataInputStream.readLong();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.doesInclude(l, l2);
    }

    private boolean doesInclude(long l, long l2) {
        if (this.mask >= 64) {
            if (l != this.ipHigh) {
                return false;
            }
            long l3 = (1L << 128 - this.mask) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            return (this.ipLow & l3) == (l2 & l3);
        }
        long l4 = (1L << 64 - this.mask) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return (this.ipHigh & l4) == (l & l4);
    }

    public int getMask() {
        return this.mask;
    }

    public InetAddress[] getIpAddresses() {
        return new InetAddress[]{this.ip};
    }
}

