/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.zones;

import com.cryptomathic.signer.api.common.zones.ZoneItem;
import com.cryptomathic.signer.common.exceptions.ZoneItemParseException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPv4AddressMask
implements ZoneItem {
    private Inet4Address ip;
    private int ipAsInt;
    private int mask;

    public Inet4Address getIpAddress() {
        return this.ip;
    }

    public int getMask() {
        return this.mask;
    }

    public static boolean looksParsable(String string) {
        String string2 = "./- ";
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c) || string2.contains("" + c)) continue;
            return false;
        }
        return true;
    }

    public IPv4AddressMask(String string) throws ZoneItemParseException {
        String[] stringArray = string.split("/");
        if (stringArray.length > 2) {
            throw new ZoneItemParseException("This does not look like an IPv4 address mask (too many separators): " + string);
        }
        String string2 = stringArray[0];
        String string3 = stringArray.length < 2 ? "32" : stringArray[1];
        try {
            String[] stringArray2 = string2.split("\\.");
            if (stringArray2.length != 4) {
                throw new ZoneItemParseException("This does not look like an IPv4 address (wrong number of dots): " + string2);
            }
            byte[] byArray = new byte[stringArray2.length];
            this.ipAsInt = 0;
            for (int i = 0; i < byArray.length; ++i) {
                short s = Short.parseShort(stringArray2[i].trim());
                if (s < 0 || s > 255) {
                    throw new ZoneItemParseException("This does not look like an IPv4 address (illegal value): " + string2);
                }
                this.ipAsInt = (this.ipAsInt << 8) + s;
                byArray[i] = (byte)s;
            }
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            if (!(inetAddress instanceof Inet4Address)) {
                throw new ZoneItemParseException("This is a valid inet address but not an IPv4 address: " + string2);
            }
            this.ip = (Inet4Address)inetAddress;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ZoneItemParseException("This does not look like an IPv4 address (bad value): " + string2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ZoneItemParseException("This does not look like an IPv4 address (unknown): " + string2);
        }
        try {
            this.mask = Integer.parseInt(string3.trim());
            if (this.mask < 0 || this.mask > 32) {
                throw new ZoneItemParseException("The IP mask should be between 0 and 32 (both inclusive): " + this.mask);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ZoneItemParseException("This does not look like an IPv4 mask (bad value): " + string3);
        }
    }

    public String toString() {
        String string = this.mask != 32 ? "/" + this.mask : "";
        return this.ip.getHostAddress() + string;
    }

    public boolean isAccessible() {
        return true;
    }

    public boolean doesInclude(int n) {
        int n2 = (int)((1L << 32 - this.mask) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        return (this.ipAsInt & n2) == (n & n2);
    }

    public boolean doesInclude(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            return false;
        }
        byte[] byArray = inetAddress.getAddress();
        int n = byArray[0] & 0xFF;
        n = (n << 8) + (byArray[1] & 0xFF);
        n = (n << 8) + (byArray[2] & 0xFF);
        n = (n << 8) + (byArray[3] & 0xFF);
        return this.doesInclude(n);
    }

    public InetAddress[] getIpAddresses() {
        return new InetAddress[]{this.getIpAddress()};
    }
}

