/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SrpType {
    SHA1_USERNAME_PASSWORD(0),
    SHA256_PASSWORD(1);

    private final int value;

    private SrpType(int n2) {
        this.value = n2;
    }

    public int getVersionValue() {
        return this.value + 1;
    }

    public static SrpType fromValue(int n) {
        for (SrpType srpType : SrpType.values()) {
            if (srpType.value != n) continue;
            return srpType;
        }
        throw new IllegalArgumentException("No such srp type in SrpType");
    }

    public static SrpType fromVersionValue(int n) {
        for (SrpType srpType : SrpType.values()) {
            if (srpType.value != n - 1) continue;
            return srpType;
        }
        throw new IllegalArgumentException("No such srp type in SrpType");
    }
}

