/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.roles;

import com.cryptomathic.signer.api.admin.message.CommandTag;
import com.cryptomathic.signer.api.common.roles.Permission;
import com.cryptomathic.signer.api.common.roles.Role;
import com.cryptomathic.signer.api.common.roles.Token;
import com.cryptomathic.signer.api.common.roles.TokenType;
import com.cryptomathic.signer.api.common.roles.Tokenizer;
import com.cryptomathic.signer.common.exceptions.RoleParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleDefinitionParser {
    private Token token;
    private Tokenizer tokenizer;

    public RoleDefinitionParser(String string) {
        if (string == null) {
            throw new NullPointerException("Role string to be parsed must be non-null");
        }
        this.tokenizer = new Tokenizer(string);
    }

    private void nextToken() {
        this.token = this.tokenizer.nextToken();
    }

    public Map<String, Role> parse() throws RoleParseException {
        HashMap<String, Role> hashMap = new HashMap<String, Role>();
        this.nextToken();
        while (this.token.tokenType != TokenType.EOF && this.token.tokenType != TokenType.PARSE_ERROR) {
            Role role = this.parseRoleDefinition();
            if (hashMap.containsKey(role.getName())) {
                throw new RoleParseException("The role " + role.getName() + " cannot be defined twice at line " + this.tokenizer.getLineNumber());
            }
            hashMap.put(role.getName(), role);
        }
        return hashMap;
    }

    private Role parseRoleDefinition() throws RoleParseException {
        if (this.token.tokenType == TokenType.LPAR) {
            this.nextToken();
            if (this.token.tokenType == TokenType.IDENTIFIER) {
                String string = this.token.str;
                if (string.length() > 64) {
                    throw new RoleParseException("Role names cannot exceed 64 characters at line " + this.tokenizer.getLineNumber());
                }
                this.nextToken();
                if (this.token.tokenType == TokenType.RPAR) {
                    this.nextToken();
                    List<Permission> list = this.parsePermissions();
                    return new Role(string, list);
                }
                throw new RoleParseException("] expected at line " + this.tokenizer.getLineNumber());
            }
            throw new RoleParseException("IDENTIFIER expected at line " + this.tokenizer.getLineNumber());
        }
        throw new RoleParseException("[ expected at line " + this.tokenizer.getLineNumber());
    }

    private List<Permission> parsePermissions() throws RoleParseException {
        ArrayList<Permission> arrayList = new ArrayList<Permission>();
        while (this.token.tokenType == TokenType.IDENTIFIER) {
            Permission permission = this.parsePermission();
            arrayList.add(permission);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Permission parsePermission() throws RoleParseException {
        if (this.token.tokenType != TokenType.IDENTIFIER) throw new RoleParseException("IDENFIER expected at line " + this.tokenizer.getLineNumber());
        String string = this.token.str;
        this.nextToken();
        int n = 1;
        String string2 = null;
        if (this.token.tokenType == TokenType.LPAR) {
            this.nextToken();
            if (this.token.tokenType != TokenType.IDENTIFIER) throw new RoleParseException("IDENTIFIER expected at line " + this.tokenizer.getLineNumber());
            string2 = this.token.str;
            this.nextToken();
            if (this.token.tokenType != TokenType.RPAR) throw new RoleParseException("] expected at line " + this.tokenizer.getLineNumber());
            this.nextToken();
            n = this.parseMultiplicity();
        } else {
            n = this.parseMultiplicity();
        }
        try {
            return new Permission(CommandTag.valueOf(string), n, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RoleParseException("Unknown command name " + string + " given as permission at line " + this.tokenizer.getLineNumber());
        }
    }

    private int parseMultiplicity() throws RoleParseException {
        if (this.token.tokenType == TokenType.COMMA) {
            this.nextToken();
            if (this.token.tokenType == TokenType.INT) {
                int n = this.token.intval;
                if (n != 1 && n != 2) {
                    throw new RoleParseException("Permission multiplicity must be either 1 or 2 at line " + this.tokenizer.getLineNumber());
                }
                this.nextToken();
                return n;
            }
            throw new RoleParseException("INT expected at line " + this.tokenizer.getLineNumber());
        }
        throw new RoleParseException("COMMA expected at line " + this.tokenizer.getLineNumber());
    }
}

