/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.communication;

import com.cryptomathic.signer.api.common.communication.SocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class TcpSocketFactory
implements SocketFactory {
    private final String server;
    private final int port;
    private final int connectionTimeout;
    private final boolean tcpNoDelay;

    public TcpSocketFactory(String string, int n, int n2, boolean bl) {
        this.server = string;
        this.port = n;
        this.connectionTimeout = n2;
        this.tcpNoDelay = bl;
    }

    public Socket getSocket() throws IOException, SocketException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.server, this.port);
        Socket socket = new Socket();
        try {
            socket.connect(inetSocketAddress, this.connectionTimeout);
        }
        catch (IOException iOException) {
            throw new IOException("Failed to open socket to " + inetSocketAddress + " - " + iOException.getMessage());
        }
        socket.setSoTimeout(this.connectionTimeout);
        socket.setTcpNoDelay(this.tcpNoDelay);
        return socket;
    }

    public void dispose(Socket socket) throws IOException {
        if (socket != null && !socket.isClosed()) {
            socket.close();
        }
    }
}

