/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.signer.api.common.communication;

import com.cryptomathic.signer.api.common.communication.CommandProcessor;
import com.cryptomathic.signer.api.common.communication.SocketFactory;
import com.cryptomathic.signer.common.exceptions.SignerException;
import com.cryptomathic.signer.common.protocol.Command;
import com.cryptomathic.signer.common.protocol.Protocol;
import com.cryptomathic.signer.common.protocol.Response;
import java.io.IOException;
import java.net.Socket;

public class DefaultCommandProcesser
implements CommandProcessor {
    private final Protocol protocol;
    private final SocketFactory socketFactory;

    public DefaultCommandProcesser(Protocol protocol) {
        this.protocol = protocol;
        this.socketFactory = null;
    }

    public DefaultCommandProcesser(Protocol protocol, SocketFactory socketFactory) {
        this.protocol = protocol;
        this.socketFactory = socketFactory;
    }

    private Response processCommand(Command command, Socket socket, boolean bl) throws IOException {
        if (command == null) {
            throw new NullPointerException("Command must not be null.");
        }
        System.out.println(command.getClass().getSimpleName());
        if (socket == null) {
            throw new NullPointerException("Socket must not be null.");
        }
        if (!socket.isConnected()) {
            throw new IOException("Socket must be connected.");
        }
        try {
            this.protocol.serializeCommand(socket.getOutputStream(), command);
        }
        catch (SignerException signerException) {
            throw new IOException("Signer exception in serialisation: " + signerException);
        }
        if (bl) {
            return this.protocol.deserializeResponse(socket.getInputStream());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response processCommand(Command command) throws IOException {
        if (this.socketFactory == null) {
            throw new NullPointerException("Socket factory must not be null.");
        }
        Response response = null;
        Socket socket = this.socketFactory.getSocket();
        try {
            response = this.processCommand(command, socket, true);
        }
        finally {
            this.socketFactory.dispose(socket);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response processCommandNoReturn(Command command) throws IOException {
        if (this.socketFactory == null) {
            throw new NullPointerException("Socket factory must not be null.");
        }
        Response response = null;
        Socket socket = this.socketFactory.getSocket();
        try {
            response = this.processCommand(command, socket, false);
        }
        finally {
            this.socketFactory.dispose(socket);
        }
        return response;
    }
}

