/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security.provider;

import com.cryptomathic.crypto.rsa.Pkcs1v1;
import com.cryptomathic.security.RSAPrivateKey;
import com.cryptomathic.security.RSAPublicKey;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;

public class SignaturePKCS1v1
extends SignatureSpi {
    protected SecureRandom appRandom;
    private byte[] _buffer = null;
    private byte[] _message = null;
    private int _offset = 0;
    private RSAPublicKey _publicKey = null;
    private RSAPrivateKey _privateKey = null;
    protected String _digest = "DEFAULT";
    private static final int BUFFERSIZE = 8192;

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof RSAPublicKey) {
            this._publicKey = (RSAPublicKey)publicKey;
            this._privateKey = null;
        } else if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            this._publicKey = new RSAPublicKey(((java.security.interfaces.RSAPublicKey)publicKey).getModulus(), ((java.security.interfaces.RSAPublicKey)publicKey).getPublicExponent());
            this._privateKey = null;
        } else {
            throw new InvalidKeyException("No support for this type of key! (" + publicKey.getClass().getName() + ")");
        }
        this._buffer = new byte[8192];
        this._offset = 0;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof RSAPrivateKey) {
            this._privateKey = (RSAPrivateKey)privateKey;
            this._publicKey = null;
        } else if (privateKey instanceof java.security.interfaces.RSAPrivateKey) {
            this._privateKey = new RSAPrivateKey(((java.security.interfaces.RSAPrivateKey)privateKey).getModulus(), ((java.security.interfaces.RSAPrivateKey)privateKey).getPrivateExponent());
            this._publicKey = null;
        } else {
            throw new InvalidKeyException("No support for this type of key! (" + privateKey.getClass().getName() + ")");
        }
        this._buffer = new byte[8192];
        this._offset = 0;
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.appRandom = random;
        this.engineInitSign(privateKey);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        if (this._buffer == null) {
            throw new SignatureException("Signature not initialized");
        }
        if (this._offset + 1 >= 8192) {
            throw new SignatureException("Message too long!");
        }
        this._buffer[this._offset++] = b;
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (this._buffer == null) {
            throw new SignatureException("Signature not initialized");
        }
        if (this._offset + len >= 8192) {
            throw new SignatureException("Message too long!");
        }
        System.arraycopy(b, off, this._buffer, this._offset, len);
        this._offset += len;
    }

    protected byte[] engineSign() throws SignatureException {
        if (this._buffer == null || this._privateKey == null) {
            throw new SignatureException("Signature not initialized!");
        }
        if (this._offset == 0) {
            throw new SignatureException("No message to sign!");
        }
        try {
            this._message = new byte[this._offset];
            System.arraycopy(this._buffer, 0, this._message, 0, this._offset);
            return Pkcs1v1.sign(this._privateKey, this._message, this._digest);
        }
        catch (Exception ex) {
            throw new SignatureException(ex.getMessage());
        }
    }

    protected int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        if (this._buffer == null || this._privateKey == null) {
            throw new SignatureException("Signature not initialized!");
        }
        if (this._offset == 0) {
            throw new SignatureException("No message to sign!");
        }
        try {
            this._message = new byte[this._offset];
            System.arraycopy(this._buffer, 0, this._message, 0, this._offset);
            byte[] _result = Pkcs1v1.sign(this._privateKey, this._message, this._digest);
            if (_result.length > len) {
                throw new SignatureException("Result is larger than bufferlength!");
            }
            System.arraycopy(_result, 0, outbuf, offset, _result.length);
            return _result.length;
        }
        catch (Exception ex) {
            if (ex instanceof SignatureException) {
                throw (SignatureException)ex;
            }
            throw new SignatureException(ex.getMessage());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this._buffer == null || this._publicKey == null) {
            throw new SignatureException("Signature not initialized!");
        }
        if (this._offset == 0) {
            throw new SignatureException("No message to verify!");
        }
        this._message = new byte[this._offset];
        System.arraycopy(this._buffer, 0, this._message, 0, this._offset);
        return Pkcs1v1.verify(this._publicKey, this._message, sigBytes);
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("DEPRECATED METHOD!");
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("DEPRECATED METHOD!");
    }
}

