/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security.provider;

import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.security.provider.Digest;
import java.security.DigestException;
import java.security.MessageDigestSpi;

public class MessageDigestBase
extends MessageDigestSpi {
    private Digest _digest;

    public MessageDigestBase(HashType type, HashPadMode padMode) {
        this._digest = new Digest(type, padMode);
    }

    public MessageDigestBase(HashType type) {
        this._digest = new Digest(type);
    }

    protected void engineUpdate(byte input) {
        this._digest.engineUpdate(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this._digest.engineUpdate(input, offset, len);
    }

    protected byte[] engineDigest() {
        return this._digest.engineDigest();
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        byte[] res = this._digest.engineDigest();
        if (offset + res.length < buf.length) {
            throw new DigestException("Output buffer to short!");
        }
        if (len < res.length) {
            throw new DigestException("len is to short");
        }
        System.arraycopy(res, 0, buf, offset, res.length);
        return res.length;
    }

    protected void engineReset() {
        this._digest.engineReset();
    }

    protected int engineGetDigestLength() {
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

