/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security.provider;

import com.cryptomathic.security.RSAPrivateCrtKey;
import com.cryptomathic.security.RSAPrivateKey;
import com.cryptomathic.security.RSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class KeyFactoryRSA
extends KeyFactorySpi {
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            RSAPrivateCrtKeySpec s = (RSAPrivateCrtKeySpec)keySpec;
            return new RSAPrivateCrtKey(s.getPrimeP(), s.getPrimeQ(), s.getPrivateExponent());
        }
        catch (ClassCastException cce) {
            try {
                RSAPrivateKeySpec s = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKey(s.getModulus(), s.getPrivateExponent());
            }
            catch (ClassCastException cce2) {
                throw new InvalidKeySpecException("Unsupported key spec");
            }
        }
    }

    public PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            RSAPublicKeySpec s = (RSAPublicKeySpec)keySpec;
            return new RSAPublicKey(s.getModulus(), s.getPublicExponent());
        }
        catch (ClassCastException cce) {
            throw new InvalidKeySpecException("Unsupported key spec");
        }
    }

    public KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (keySpec.getName().equals("java.security.spec.RSAPrivateCrtKeySpec")) {
            try {
                RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
                return new RSAPrivateCrtKeySpec(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
            }
            catch (ClassCastException cce) {
                throw new InvalidKeySpecException("Not a CRM crt private key");
            }
        }
        if (keySpec.getName().equals("java.security.spec.RSAPrivateKeySpec")) {
            try {
                RSAPrivateKey k = (RSAPrivateKey)key;
                return new RSAPrivateKeySpec(k.getModulus(), k.getPrivateExponent());
            }
            catch (ClassCastException cce) {
                throw new InvalidKeySpecException("Not a CRM private key");
            }
        }
        if (keySpec.getName().equals("java.security.spec.RSAPublicKeySpec")) {
            try {
                RSAPublicKey k = (RSAPublicKey)key;
                return new RSAPublicKeySpec(k.getModulus(), k.getPublicExponent());
            }
            catch (ClassCastException cce) {
                throw new InvalidKeySpecException("Not a CRM public key");
            }
        }
        throw new InvalidKeySpecException("Not a CRM rsa key");
    }

    public Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            java.security.interfaces.RSAPrivateCrtKey k = (java.security.interfaces.RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKey(k.getPrimeP(), k.getPrimeQ(), k.getPrivateExponent());
        }
        catch (ClassCastException cce) {
            try {
                java.security.interfaces.RSAPrivateKey k = (java.security.interfaces.RSAPrivateKey)key;
                return new RSAPrivateKey(k.getModulus(), k.getPrivateExponent());
            }
            catch (ClassCastException cce2) {
                try {
                    java.security.interfaces.RSAPublicKey k = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKey(k.getModulus(), k.getPublicExponent());
                }
                catch (ClassCastException cce3) {
                    throw new InvalidKeyException("Unsupported key type");
                }
            }
        }
    }
}

