/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

class CRMKey
implements Serializable {
    byte[] key;
    Date creation_date;
    public byte[] zero_iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    public CRMKey() {
        this.creation_date = new Date();
        this.key = null;
    }

    public CRMKey(Key k, char[] password) {
        this.creation_date = new Date();
        this.setKey(k, password);
    }

    public Date getCreationDate() {
        return this.creation_date;
    }

    public boolean equals(CRMKey k) {
        return k.key.equals(this.key) && k.creation_date.equals(this.creation_date);
    }

    public Key getKey(char[] password) {
        try {
            byte[] passwd = new String(password).getBytes();
            IvParameterSpec ivparam = new IvParameterSpec(this.zero_iv);
            Cipher des = Cipher.getInstance("DESede/CBC/PADFF16", "Cryptomathic");
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG", "Cryptomathic");
            sr.setSeed(passwd);
            KeyGenerator kg = KeyGenerator.getInstance("DESede", "Cryptomathic");
            kg.init(sr);
            SecretKey sk = kg.generateKey();
            des.init(2, (Key)sk, ivparam);
            byte[] dec_key_passwd = des.doFinal(this.key);
            if (passwd.length > dec_key_passwd.length) {
                // empty if block
            }
            int offset = dec_key_passwd.length - passwd.length;
            int i = 0;
            while (i < passwd.length) {
                if (dec_key_passwd[offset] != passwd[i]) {
                    // empty if block
                }
                ++i;
                ++offset;
            }
            ByteArrayInputStream b = new ByteArrayInputStream(dec_key_passwd, 0, dec_key_passwd.length - passwd.length);
            ObjectInputStream ois = new ObjectInputStream(b);
            Key k = (Key)ois.readObject();
            ois.close();
            b.close();
            return k;
        }
        catch (IOException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (NoSuchPaddingException e) {
        }
        catch (InvalidAlgorithmParameterException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public void setKey(Key k, char[] password) {
        if (k == null) {
            throw new NullPointerException("Unable to store null key");
        }
        if (password == null) {
            throw new NullPointerException("Unable to store key null with null password");
        }
        try {
            byte[] passwd = new String(password).getBytes();
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            ObjectOutputStream oos1 = new ObjectOutputStream(b);
            oos1.writeObject(k);
            oos1.close();
            b.write(passwd, 0, passwd.length);
            byte[] temp = b.toByteArray();
            b.close();
            IvParameterSpec ivparam = new IvParameterSpec(this.zero_iv);
            Cipher des = Cipher.getInstance("DESede/CBC/PADFF16", "Cryptomathic");
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG", "Cryptomathic");
            sr.setSeed(passwd);
            KeyGenerator kg = KeyGenerator.getInstance("DESede", "Cryptomathic");
            kg.init(sr);
            SecretKey sk = kg.generateKey();
            des.init(1, (Key)sk, ivparam);
            this.key = des.doFinal(temp);
        }
        catch (IOException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (NoSuchPaddingException e) {
        }
        catch (InvalidAlgorithmParameterException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
    }
}

