/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security;

import com.cryptomathic.security.EKeyEncoding;
import com.cryptomathic.security.EncodingUtil;
import java.math.BigInteger;
import java.security.PrivateKey;

public class RSAPrivateKey
implements PrivateKey,
java.security.interfaces.RSAPrivateKey {
    protected BigInteger _modulus;
    protected BigInteger _exponent;

    public RSAPrivateKey() {
    }

    public RSAPrivateKey(BigInteger modulus, BigInteger exponent) {
        this._modulus = modulus;
        this._exponent = exponent;
    }

    public RSAPrivateKey(byte[] encoding) throws EKeyEncoding {
        this._modulus = EncodingUtil.decodeBI(encoding, 0);
        this._exponent = EncodingUtil.decodeBI(encoding, 2 + EncodingUtil.encodeSize(encoding, 0));
    }

    public BigInteger exp(BigInteger x) {
        return x.modPow(this.getPrivateExponent(), this.getModulus());
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "Internal Cryptomathic Format";
    }

    public byte[] getEncoded() {
        byte[] modulusEnc = EncodingUtil.encodeBI(this._modulus);
        byte[] exponentEnc = EncodingUtil.encodeBI(this._exponent);
        byte[] retVal = new byte[modulusEnc.length + exponentEnc.length];
        System.arraycopy(modulusEnc, 0, retVal, 0, modulusEnc.length);
        System.arraycopy(exponentEnc, 0, retVal, modulusEnc.length, exponentEnc.length);
        return retVal;
    }

    public BigInteger getModulus() {
        return this._modulus;
    }

    public BigInteger getPrivateExponent() {
        return this._exponent;
    }
}

