/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.security;

import com.cryptomathic.crypto.primes.EPrimeParameterException;
import com.cryptomathic.crypto.primes.PrimeGenerator;
import com.cryptomathic.security.EInvalidAlgorithmParameterException;
import com.cryptomathic.security.RSAPrivateCrtKey;
import com.cryptomathic.security.RSAPrivateKey;
import com.cryptomathic.security.RSAPublicKey;
import com.cryptomathic.security.spec.RSAParameterSpec;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;

public class KeyPairGenerator {
    private static BigInteger onE = BigInteger.valueOf(1L);
    private Random _random;
    private RSAParameterSpec _parameterSpec = new RSAParameterSpec(1024);
    private PrimeGenerator _primeGenerator;

    public void initialize(int strength, Random random, PrimeGenerator primeGenerator) {
        this._parameterSpec = new RSAParameterSpec(strength);
        this._random = random;
        this._primeGenerator = primeGenerator;
    }

    public void initialize(int strength, SecureRandom random) {
        this.initialize(strength, (Random)random, new PrimeGenerator(random));
    }

    public void initialize(AlgorithmParameterSpec params, Random random, PrimeGenerator primeGenerator) throws EInvalidAlgorithmParameterException {
        if (params != null) {
            try {
                this._parameterSpec = (RSAParameterSpec)params;
            }
            catch (ClassCastException e) {
                throw new EInvalidAlgorithmParameterException("Incorrect parameter class");
            }
        }
        try {
            this._parameterSpec = (RSAParameterSpec)params;
        }
        catch (ClassCastException e) {
            throw new EInvalidAlgorithmParameterException("Incorrect parameter class");
        }
        this._random = random;
        this._primeGenerator = primeGenerator;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws EInvalidAlgorithmParameterException {
        this.initialize(params, (Random)random, new PrimeGenerator(random));
    }

    public KeyPair generateKeyPair() {
        BigInteger d;
        BigInteger Q;
        BigInteger P;
        int pSize;
        BigInteger pSeed;
        BigInteger modulusSeed;
        BigInteger e = this._parameterSpec.e;
        int size = this._parameterSpec.strength;
        int modP = this._parameterSpec.modP;
        int resP = this._parameterSpec.resP;
        int modQ = this._parameterSpec.modQ;
        int resQ = this._parameterSpec.resQ;
        if (this._random == null) {
            this._random = new SecureRandom();
        }
        if (this._primeGenerator == null) {
            this._primeGenerator = new PrimeGenerator(this._random);
        }
        if ((modulusSeed = new BigInteger(size, this._random)).bitLength() < size) {
            modulusSeed = modulusSeed.shiftLeft(size - modulusSeed.bitLength());
        }
        if ((pSeed = new BigInteger(pSize = size / 2 + size % 2, this._random)).bitLength() < pSize) {
            pSeed = pSeed.shiftLeft(pSize - pSeed.bitLength());
        }
        try {
            P = this._primeGenerator.getPrime(pSeed, modP, resP, e);
            Q = this._primeGenerator.getPrime(modulusSeed.divide(P), modQ, resQ, e);
        }
        catch (EPrimeParameterException ex) {
            return null;
        }
        catch (ArithmeticException ex) {
            return null;
        }
        BigInteger mod = P.multiply(Q);
        if (mod.bitLength() != size) {
            return this.generateKeyPair();
        }
        BigInteger euler = P.subtract(onE).multiply(Q.subtract(onE));
        try {
            if (e == null) {
                d = new BigInteger(size, this._random);
                d = d.remainder(euler);
                while (d.gcd(euler).compareTo(onE) != 0) {
                    d = new BigInteger(size, this._random);
                    d = d.remainder(euler);
                }
                e = d.modInverse(euler);
            } else {
                d = e.modInverse(euler);
            }
        }
        catch (ArithmeticException ex) {
            return null;
        }
        RSAPublicKey publicKey = new RSAPublicKey(mod, e);
        if (!this._parameterSpec.crtRequired) {
            RSAPrivateKey privateKey = new RSAPrivateKey(mod, d);
            return new KeyPair(publicKey, privateKey);
        }
        RSAPrivateCrtKey privateKey = new RSAPrivateCrtKey(P, Q, d);
        return new KeyPair(publicKey, privateKey);
    }
}

