/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.misc;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Null;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.ASN1.SequenceTemplateMember;
import com.cryptomathic.PKCS12.PBKDFsha;
import com.cryptomathic.PKCS12.PKCS12PbeParams;
import com.cryptomathic.PKCS5.PBEParameter;
import com.cryptomathic.crypto.hash.HashException;
import com.cryptomathic.crypto.hash.HashMech;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.misc.AlgorithmIdentifierParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AlgorithmIdentifier
extends Sequence {
    public ObjectIdentifier algorithm;
    public AlgorithmIdentifierParameters parameters;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.algorithm = (ObjectIdentifier)v.get(0);
        this.parameters = (AlgorithmIdentifierParameters)v.get(1);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(2);
        v.add(this.algorithm);
        v.add(this.parameters);
        return v;
    }

    public SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ObjectIdentifier.class);
        SequenceTemplateMember sequenceTemplateMember = new SequenceTemplateMember(AlgorithmIdentifierParameters.class, true);
        sequenceTemplateMember.setAnyDefinedBy(0);
        template.addMember(sequenceTemplateMember);
        return template;
    }

    public byte[] Hash(byte[] message) throws NoSuchAlgorithmException, ASN1Exception, HashException {
        String algorithmtype = OIDs.OID2AlgString(this.algorithm.value);
        HashType hmode = null;
        if ("SHA1".equals(algorithmtype)) {
            hmode = HashType.SHA;
        }
        if ("MD5".equals(algorithmtype)) {
            hmode = HashType.MD5;
        }
        if ("RIPEMD160".equals(algorithmtype)) {
            hmode = HashType.RIPEMD160;
        }
        if ("SHA256".equals(algorithmtype)) {
            hmode = HashType.SHA256;
        }
        if ("SHA384".equals(algorithmtype)) {
            hmode = HashType.SHA384;
        }
        if ("SHA512".equals(algorithmtype)) {
            hmode = HashType.SHA512;
        }
        return HashMech.hash_mes(hmode, HashPadMode.NOPAD, message, message.length);
    }

    public String toAlgString() throws ASN1Exception {
        return OIDs.OID2AlgString(this.algorithm.value);
    }

    public static AlgorithmIdentifier makeAlgorithm(String alg) throws ASN1Exception {
        AlgorithmIdentifier res = new AlgorithmIdentifier();
        res.setAlgorithm(alg);
        return res;
    }

    public static AlgorithmIdentifier makeAlgorithm(Cipher cipher) throws ASN1Exception, InvalidParameterSpecException {
        AlgorithmIdentifier res = new AlgorithmIdentifier();
        res.setAlgorithm(cipher.getAlgorithm(), cipher.getParameters());
        return res;
    }

    public static AlgorithmIdentifier makeAlgorithm(byte[] oid, ASN1Object parameters) throws ASN1Exception {
        AlgorithmIdentifier res = new AlgorithmIdentifier();
        res.algorithm = new ObjectIdentifier(oid);
        res.parameters = new AlgorithmIdentifierParameters(parameters);
        return res;
    }

    public void setAlgorithm(String alg) throws ASN1Exception {
        if ("RSA".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.rsaEncryption);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("SHA1withRSA".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.sha1withRSAEncryption);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("SHA256withRSA".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.sha256withRSAEncryption);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("MD5withRSA".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.md5withRSAEncryption);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("SHA1".equals(alg) || "SHA".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_oiw_sha1);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("SHA256".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_nist_sha256);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("SHA384".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_nist_sha384);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("SHA512".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_nist_sha512);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("MD5".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_md5);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("RIPEMD160".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_ripemd160);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else {
            throw new ASN1Exception("Unknown alg " + alg);
        }
    }

    public void setAlgorithm(String alg, AlgorithmParameters algParameters) throws ASN1Exception, InvalidParameterSpecException {
        if ("DES/CBC/PKCS5Padding".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.oiw_des_cbc);
            IvParameterSpec iv = algParameters.getParameterSpec(IvParameterSpec.class);
            this.parameters = new AlgorithmIdentifierParameters(new OctetString(iv.getIV()));
        } else {
            this.setAlgorithm(alg);
        }
    }

    public static AlgorithmIdentifier makeSignatureAlgorithm(String alg) throws ASN1Exception {
        AlgorithmIdentifier res = new AlgorithmIdentifier();
        res.setSignatureAlgorithm(alg);
        return res;
    }

    public void setSignatureAlgorithm(String alg) throws ASN1Exception {
        if (!("SHA1/RSA".equals(alg) || "SHA1withRSA".equals(alg) || "SHA256/RSA".equals(alg) || "SHA256withRSA".equals(alg) || "MD5/RSA".equals(alg) || "MD5withRSA".equals(alg))) {
            throw new ASN1Exception("Unknown alg " + alg);
        }
        this.algorithm = new ObjectIdentifier(OIDs.rsaEncryption);
        this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
    }

    public static AlgorithmIdentifier makeDigestAlgorithm(String alg) throws ASN1Exception {
        AlgorithmIdentifier res = new AlgorithmIdentifier();
        res.setSignatureAlgorithm(alg);
        return res;
    }

    public void setDigestAlgorithm(String alg) throws ASN1Exception {
        if ("SHA1/RSA".equals(alg) || "SHA1withRSA".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_oiw_sha1);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("SHA256/RSA".equals(alg) || "SHA256withRSA".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_nist_sha256);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else if ("MD5/RSA".equals(alg) || "MD5withRSA".equals(alg)) {
            this.algorithm = new ObjectIdentifier(OIDs.id_md5);
            this.parameters = new AlgorithmIdentifierParameters(new ASN1Null());
        } else {
            throw new ASN1Exception("Unknown alg " + alg);
        }
    }

    public AlgorithmParameterSpec toAlgParams() {
        if (this.algorithm.equals(OIDs.oiw_des_cbc) || this.algorithm.equals(OIDs.id_des_ede3_cbc)) {
            OctetString iv = (OctetString)this.parameters.value;
            IvParameterSpec res = new IvParameterSpec(iv.value);
            return res;
        }
        return null;
    }

    public byte[] decrypt(String password, byte[] bs) throws ASN1Exception, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        Sequence params;
        KeySpec keyspec = null;
        SecretKeyFactory secretKeyFactory = null;
        String alg = null;
        AlgorithmParameterSpec algspec = null;
        if (this.algorithm.equals(OIDs.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
            params = (PKCS12PbeParams)this.parameters.value;
            try {
                keyspec = new PBEKeySpec(password.toCharArray(), params.salt.value, params.iterations.getInteger());
                alg = "PBEWithSHA1AndDESede";
                algspec = new PBEParameterSpec(params.salt.value, params.iterations.getInteger());
                secretKeyFactory = SecretKeyFactory.getInstance("PBE");
            }
            catch (NoSuchAlgorithmException e) {
                byte[] keyvalue = PBKDFsha.PBKDF(password, params.salt.value, 1, params.iterations.getInteger(), 24);
                byte[] iv = PBKDFsha.PBKDF(password, params.salt.value, 2, params.iterations.getInteger(), 8);
                keyspec = new DESedeKeySpec(keyvalue);
                alg = "DESede/CBC/PKCS5Padding";
                algspec = new IvParameterSpec(iv);
                secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            }
        } else if (this.algorithm.equals(OIDs.pbeWithSHAAnd40BitRC2_CBC)) {
            params = (PKCS12PbeParams)this.parameters.value;
            try {
                keyspec = new PBEKeySpec(password.toCharArray(), params.salt.value, params.iterations.getInteger());
                alg = "PBEWithSHA1AndRC2_40";
                algspec = new PBEParameterSpec(params.salt.value, params.iterations.getInteger());
                secretKeyFactory = SecretKeyFactory.getInstance("PBE");
            }
            catch (NoSuchAlgorithmException e) {
                byte[] keyvalue = PBKDFsha.PBKDF(password, params.salt.value, 1, params.iterations.getInteger(), 5);
                byte[] iv = PBKDFsha.PBKDF(password, params.salt.value, 2, params.iterations.getInteger(), 8);
                keyspec = new SecretKeySpec(keyvalue, "RC2");
                alg = "RC2/CBC/PKCS5Padding";
                algspec = new RC2ParameterSpec(keyvalue.length * 8, iv);
                secretKeyFactory = SecretKeyFactory.getInstance("RC2");
            }
        } else if (this.algorithm.equals(OIDs.pbeWithMD5AndDES_CBC)) {
            params = (PBEParameter)this.parameters.value;
            keyspec = new PBEKeySpec(password.toCharArray(), ((PBEParameter)params).salt.value, ((PBEParameter)params).iterations.getInteger());
            alg = "PBEWithMD5AndDES";
            algspec = new PBEParameterSpec(((PBEParameter)params).salt.value, ((PBEParameter)params).iterations.getInteger());
            secretKeyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        }
        if (secretKeyFactory == null) {
            throw new ASN1Exception("Unknown algorithm");
        }
        SecretKey key = secretKeyFactory.generateSecret(keyspec);
        Cipher cipher = Cipher.getInstance(alg, secretKeyFactory.getProvider());
        cipher.init(2, (Key)key, algspec);
        return cipher.doFinal(bs);
    }
}

