/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.luxtrust.signinglibrary.general;

public class Hex {
    private static final char[] hexNibbles = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Hex() {
    }

    public static String encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[2 * byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[2 * i] = hexNibbles[(byArray[i] & 0xF0) >> 4];
            cArray[2 * i + 1] = hexNibbles[(byArray[i] & 0xF) >> 0];
        }
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex string must have even length");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            char c = string.charAt(i * 2 + 0);
            char c2 = string.charAt(i * 2 + 1);
            int n = Hex.decodeNibble(c2);
            int n2 = Hex.decodeNibble(c);
            byArray[i] = (byte)(n + (n2 << 4));
        }
        return byArray;
    }

    public static int decodeNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Hex string may only contain 0-9, a-f and A-F");
    }

    public static char encodeNibble(int n) {
        if (n >= 0 && n <= 9) {
            char c = (char)(48 + n);
            return c;
        }
        if (n >= 10 && n <= 15) {
            char c = (char)(65 + n - 10);
            return c;
        }
        throw new IllegalArgumentException("value must fit in a nibble");
    }

    public static String encode32Bit(int n) {
        String string = Integer.toHexString(n);
        return "00000000".substring(0, 8 - string.length()) + string;
    }

    public static boolean isDecimalDigits(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Hex.isHexDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isValid(String string) {
        if (null == string || 0 == string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Hex.isHexDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

