/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.luxtrust.signinglibrary;

import com.cryptomathic.luxtrust.signinglibrary.AdvancedCSSignatureHandlerInterface;
import com.cryptomathic.luxtrust.signinglibrary.CSSignatureHandler4;
import com.cryptomathic.luxtrust.signinglibrary.common.Result;
import com.cryptomathic.luxtrust.signinglibrary.common.ResultCodes;
import com.cryptomathic.luxtrust.signinglibrary.common.SignatureResult;
import com.cryptomathic.luxtrust.signinglibrary.general.Settings;
import com.cryptomathic.signer.api.user.KeyEntry;
import com.cryptomathic.signer.sdk.user.SignerUserConnection;
import com.cryptomathic.signer.sdk.user.SignerUserException;
import com.cryptomathic.signer.sdk.user.crypto.DecryptFailedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class AdvancedCSSignatureHandler4
extends CSSignatureHandler4
implements AdvancedCSSignatureHandlerInterface {
    public AdvancedCSSignatureHandler4(Settings settings) {
        super(settings);
    }

    private SignatureResult validateParameters(String string, byte[] byArray, AdvancedCSSignatureHandlerInterface.HashAlgorithm hashAlgorithm, AdvancedCSSignatureHandlerInterface.SignatureEnvelope signatureEnvelope) {
        if (string == null || string.length() == 0) {
            return new SignatureResult(ResultCodes.ERROR_BAD_PARAMETER, "OTP must not be NULL or have length zero.");
        }
        if (byArray == null) {
            return new SignatureResult(ResultCodes.ERROR_BAD_PARAMETER, "Hash to be signed must not be NULL.");
        }
        if (hashAlgorithm == null && signatureEnvelope == AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS7) {
            return new SignatureResult(ResultCodes.ERROR_BAD_PARAMETER, "Hash algorithm parameter must not be NULL for envelope type PKCS#7.");
        }
        if (hashAlgorithm != null && hashAlgorithm != AdvancedCSSignatureHandlerInterface.HashAlgorithm.MD5 && hashAlgorithm != AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA1 && hashAlgorithm != AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA256 && hashAlgorithm != AdvancedCSSignatureHandlerInterface.HashAlgorithm.MD5SHA1) {
            return new SignatureResult(ResultCodes.ERROR_BAD_PARAMETER, "Unsupported hash algorithm '" + (Object)((Object)hashAlgorithm) + "' specified.");
        }
        if (signatureEnvelope == null) {
            return new SignatureResult(ResultCodes.ERROR_BAD_PARAMETER, "Envelope parameter must not be NULL.");
        }
        if (signatureEnvelope != null && signatureEnvelope != AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS1 && signatureEnvelope != AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS7) {
            return new SignatureResult(ResultCodes.ERROR_BAD_PARAMETER, "Unsupported envelope type '" + (Object)((Object)signatureEnvelope) + "' specified.");
        }
        if (signatureEnvelope == AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS7 && hashAlgorithm == AdvancedCSSignatureHandlerInterface.HashAlgorithm.MD5SHA1) {
            return new SignatureResult(ResultCodes.ERROR_BAD_PARAMETER, "Unsupported combination of envelope type '" + (Object)((Object)signatureEnvelope) + "' and hash algorithm '" + (Object)((Object)hashAlgorithm) + "' specified.");
        }
        return null;
    }

    public SignatureResult createAuthenticationSignatureHash(String string, byte[] byArray, AdvancedCSSignatureHandlerInterface.HashAlgorithm hashAlgorithm, AdvancedCSSignatureHandlerInterface.SignatureEnvelope signatureEnvelope) {
        SignatureResult signatureResult = null;
        signatureResult = this.validateParameters(string, byArray, hashAlgorithm, signatureEnvelope);
        if (signatureResult != null) {
            return signatureResult;
        }
        return this.createSignatureInternal(string, byArray, true, false, hashAlgorithm.toString(), signatureEnvelope.toString());
    }

    public SignatureResult createSignatureHash(String string, byte[] byArray, AdvancedCSSignatureHandlerInterface.HashAlgorithm hashAlgorithm, AdvancedCSSignatureHandlerInterface.SignatureEnvelope signatureEnvelope) {
        SignatureResult signatureResult = null;
        signatureResult = this.validateParameters(string, byArray, hashAlgorithm, signatureEnvelope);
        if (signatureResult != null) {
            return signatureResult;
        }
        if (hashAlgorithm == null && signatureEnvelope != AdvancedCSSignatureHandlerInterface.SignatureEnvelope.PKCS7) {
            hashAlgorithm = AdvancedCSSignatureHandlerInterface.HashAlgorithm.SHA1;
        }
        return this.createSignatureInternal(string, byArray, true, false, hashAlgorithm.toString(), signatureEnvelope.toString());
    }

    public X509Certificate getCertificate() throws CertificateException {
        if (!this.connection) {
            this.last_error = "Signer connection not initialised.";
            return null;
        }
        if (!this.verifyLogon()) {
            this.last_error = "User not logged in.";
            return null;
        }
        SignerUserConnection signerUserConnection = null;
        try {
            signerUserConnection = new SignerUserConnection(this.settings.getSignerURL(), this.serverN, this.serverG);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CertificateException("Could not establish connection to server.");
        }
        Result result = this.logInAndCheckAuth(signerUserConnection, this.userName, this.userPassword);
        if (result.getResultCode() != ResultCodes.OK) {
            throw new CertificateException("Unable to log in.");
        }
        KeyEntry keyEntry = null;
        try {
            keyEntry = this.findSigningKeyPair(signerUserConnection);
        }
        catch (CSSignatureHandler4.InternalException internalException) {
            throw new CertificateException("Internal exception.");
        }
        catch (IOException iOException) {
            throw new CertificateException("Problem communicating with signer.");
        }
        catch (SignerUserException signerUserException) {
            throw new CertificateException("No signing key pair found on server.");
        }
        catch (DecryptFailedException decryptFailedException) {
            throw new CertificateException("Could not decrypt data from signer.");
        }
        byte[] byArray = keyEntry.certificateBytes;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
    }
}

