/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gfp;

import com.cryptomathic.ecc.gfp.Curve;
import com.cryptomathic.ecc.gfp.FieldElement;
import com.cryptomathic.ecc.gfp.Point;
import java.math.BigInteger;
import java.util.Vector;

class PointElement {
    public FieldElement x;
    public FieldElement y;
    public Vector fixed_comb_multiplas = new Vector();
    public int width = 0;

    public PointElement(FieldElement x, FieldElement y) {
        this.x = x;
        this.y = y;
    }

    public PointElement(PointElement P) {
        this.x = new FieldElement(P.x);
        this.y = new FieldElement(P.y);
        this.fixed_comb_multiplas = P.fixed_comb_multiplas;
        this.width = P.width;
    }

    public PointElement(byte[] serialization, BigInteger p) {
        int len = (p.bitLength() + 7) / 8;
        if (serialization.length == 1) {
            if (serialization[0] != 0) {
                throw new IllegalArgumentException("Bad serialization");
            }
            this.x = FieldElement.Zero(p);
            this.y = FieldElement.Zero(p);
        } else {
            if (serialization.length == len + 1) {
                throw new IllegalArgumentException("Point compression not supported");
            }
            if (serialization.length == 2 * len + 1) {
                if (serialization[0] != 4) {
                    throw new IllegalArgumentException("Bad serialization");
                }
                byte[] X = new byte[len];
                System.arraycopy(serialization, 1, X, 0, len);
                this.x = new FieldElement(X, p);
                byte[] Y = new byte[len];
                System.arraycopy(serialization, 1 + len, Y, 0, len);
                this.y = new FieldElement(Y, p);
            } else {
                throw new IllegalArgumentException("Bad serialization");
            }
        }
    }

    public byte[] toByteArray(BigInteger f) {
        int fieldlength = (f.bitLength() + 7) / 8;
        int len = 2 * fieldlength + 1;
        byte[] bytes = new byte[len];
        bytes[0] = 4;
        byte[] xs = this.x.toByteArray();
        int i = xs.length - 1;
        for (int j = fieldlength; i >= 0 && j >= 1; --i, --j) {
            bytes[j] = xs[i];
        }
        byte[] ys = this.y.toByteArray();
        int i2 = ys.length - 1;
        for (int j = 2 * fieldlength; i2 >= 0 && j >= 1 + fieldlength; --i2, --j) {
            bytes[j] = ys[i2];
        }
        return bytes;
    }

    public boolean equals(PointElement P) {
        return this.x.equals(P.x) && this.y.equals(P.y);
    }

    public boolean isOnCurve(Curve C) {
        FieldElement left = FieldElement.multiply(this.y, this.y);
        FieldElement right = FieldElement.multiply(this.x, this.x);
        right.multiply(this.x);
        right.add(FieldElement.multiply(C.a, this.x));
        right.add(C.b);
        return left.equals(right);
    }

    public String toString() {
        return this.x.toString() + ',' + this.y.toString();
    }

    public boolean isInfinity(Curve C) {
        return this.equals(Point.Infinity(C).getPointElement());
    }
}

