/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gfp;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.crypto.util.Primality;
import com.cryptomathic.ecc.ASN1.ECParameters;
import com.cryptomathic.ecc.Point;
import com.cryptomathic.ecc.gfp.Field;
import com.cryptomathic.ecc.gfp.FieldElement;
import com.cryptomathic.ecc.gfp.PointElement;
import com.cryptomathic.util.ByteArray;
import java.math.BigInteger;

public class Curve
extends com.cryptomathic.ecc.Curve {
    FieldElement a;
    FieldElement b;
    BigInteger p;
    PointElement G;
    BigInteger order;

    Curve(Curve C) {
        this.a = C.a;
        this.b = C.b;
        this.p = C.p;
        this.G = C.G;
        this.order = C.order;
    }

    Curve(BigInteger p, FieldElement a, FieldElement b, PointElement G, BigInteger order) {
        this.p = p;
        this.a = a;
        this.b = b;
        this.G = G;
        this.order = order;
    }

    public Curve(ECParameters curve) throws ASN1Exception {
        this.p = ((ASN1Integer)curve.fieldID.parameters.value).getBigInteger();
        this.a = new FieldElement(curve.curve.a, this.p);
        this.b = new FieldElement(curve.curve.b, this.p);
        this.G = new PointElement(curve.base.value, this.p);
        this.order = curve.order.getBigInteger();
    }

    public static Curve GF1009() {
        BigInteger p = new BigInteger("1009");
        PointElement G = new PointElement(new FieldElement(32, p), new FieldElement(737, p));
        BigInteger order = new BigInteger("53");
        return new Curve(p, new FieldElement(71, p), new FieldElement(602, p), G, order);
    }

    public static Curve GFp192b() {
        BigInteger p = new BigInteger("6277101735386680763835789423207666416083908700390324961279");
        PointElement G = new PointElement(new FieldElement(ByteArray.toByteArray("188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012"), p), new FieldElement(ByteArray.toByteArray("07192b95ffc8da78631011ed6b24cdd573f977a11e794811"), p));
        BigInteger order = new BigInteger("6277101735386680763835789423176059013767194773182842284081");
        FieldElement b = new FieldElement(ByteArray.toByteArray("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1"), p);
        return new Curve(p, new FieldElement(-3, p), b, G, order);
    }

    public static Curve GFp224b() {
        BigInteger p = new BigInteger("26959946667150639794667015087019630673557916260026308143510066298881");
        PointElement G = new PointElement(new FieldElement(ByteArray.toByteArray("b70e0cbd6bb4bf7f321390b94a03c1d356c21122343280d6115c1d21"), p), new FieldElement(ByteArray.toByteArray("bd376388b5f723fb4c22dfe6cd4375a05a07476444d5819985007e34"), p));
        BigInteger order = new BigInteger("26959946667150639794667015087019625940457807714424391721682722368061");
        FieldElement b = new FieldElement(ByteArray.toByteArray("b4050a850c04b3abf54132565044b0b7d7bfd8ba270b39432355ffb4"), p);
        return new Curve(p, new FieldElement(-3, p), b, G, order);
    }

    public static Curve GFp256b() {
        BigInteger p = new BigInteger("115792089210356248762697446949407573530086143415290314195533631308867097853951");
        PointElement G = new PointElement(new FieldElement(ByteArray.toByteArray("6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296"), p), new FieldElement(ByteArray.toByteArray("4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5"), p));
        BigInteger order = new BigInteger("115792089210356248762697446949407573529996955224135760342422259061068512044369");
        FieldElement b = new FieldElement(ByteArray.toByteArray("5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b"), p);
        return new Curve(p, new FieldElement(-3, p), b, G, order);
    }

    public static Curve GFp384b() {
        BigInteger p = new BigInteger("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319");
        PointElement G = new PointElement(new FieldElement(ByteArray.toByteArray("aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7"), p), new FieldElement(ByteArray.toByteArray("3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f"), p));
        BigInteger order = new BigInteger("39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643");
        FieldElement b = new FieldElement(ByteArray.toByteArray("b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef"), p);
        return new Curve(p, new FieldElement(-3, p), b, G, order);
    }

    public static Curve GFp521b() {
        BigInteger p = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151");
        PointElement G = new PointElement(new FieldElement(ByteArray.toByteArray("c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66"), p), new FieldElement(ByteArray.toByteArray("011839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650"), p));
        BigInteger order = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449");
        FieldElement b = new FieldElement(ByteArray.toByteArray("0051953eb9618e1c9a1f929a21a0b68540eea2da725b99b315f3b8b489918ef109e156193951ec7e937b1652c0bd3bb1bf073573df883d2c34f1ef451fd46b503f00"), p);
        return new Curve(p, new FieldElement(-3, p), b, G, order);
    }

    public static Curve secp160r1() {
        BigInteger p = new BigInteger(1, ByteArray.toByteArray("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF"));
        PointElement G = new PointElement(new FieldElement(ByteArray.toByteArray("4A96B5688EF573284664698968C38BB913CBFC82"), p), new FieldElement(ByteArray.toByteArray("23A628553168947D59DCC912042351377AC5FB32"), p));
        BigInteger order = new BigInteger(ByteArray.toByteArray("0100000000000000000001F4C8F927AED3CA752257"));
        FieldElement a = new FieldElement(ByteArray.toByteArray("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC"), p);
        FieldElement b = new FieldElement(ByteArray.toByteArray("1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45"), p);
        return new Curve(p, a, b, G, order);
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public FieldElement geta() {
        return this.a;
    }

    public FieldElement getb() {
        return this.b;
    }

    public BigInteger getp() {
        return this.p;
    }

    public Point getG() {
        return new com.cryptomathic.ecc.gfp.Point(this.G, this);
    }

    FieldElement getj() {
        FieldElement j = new FieldElement(4, this.p);
        j.multiply(this.a);
        j.multiply(this.a);
        j.multiply(this.a);
        j.add(FieldElement.multiply(new FieldElement(27, this.p), FieldElement.multiply(this.b, this.b)));
        return j;
    }

    public boolean validate() {
        Primality primality = new Primality();
        if (!primality.isProbablePrime(this.p, 100)) {
            return false;
        }
        if (this.getj().isZero()) {
            return false;
        }
        if (!this.G.isOnCurve(this)) {
            return false;
        }
        if (!primality.isProbablePrime(this.order, 100)) {
            return false;
        }
        int log2n = this.order.bitLength();
        if (log2n <= 160) {
            return false;
        }
        if (this.order.multiply(this.order).compareTo(this.p.multiply(new BigInteger("16"))) <= 0) {
            return false;
        }
        if (!com.cryptomathic.ecc.gfp.Point.scalarMultiply(this.G, this.order, this).isInfinity()) {
            return false;
        }
        if (!Curve.MOVcondition(this.p, this.order)) {
            return false;
        }
        return !this.p.equals(this.order);
    }

    public boolean equals(Curve C) {
        return this.a.equals(C.a) && this.b.equals(C.b) && this.p.equals(C.p) && this.G.equals(C.G) && this.order.equals(C.order);
    }

    public boolean equals(Object x) {
        if (!(x instanceof Curve)) {
            return false;
        }
        return this.equals((Curve)x);
    }

    public byte[] getA() {
        return this.a.toByteArray();
    }

    public byte[] getB() {
        return this.b.toByteArray();
    }

    public String toString() {
        return "a: " + this.a.toString() + ", " + "b: " + this.b.toString() + ", " + "Prime: " + this.p.toString() + ", " + "G: " + this.G.toString() + ", " + "Order: " + this.order.toString();
    }

    public com.cryptomathic.ecc.Field getField() {
        return new Field(this.p);
    }
}

