/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gf2;

import com.cryptomathic.ecc.gf2.Curve;
import com.cryptomathic.ecc.gf2.Field;
import com.cryptomathic.ecc.gf2.FieldElement;

class PointElement {
    public FieldElement x;
    public FieldElement y;

    public PointElement(FieldElement x, FieldElement y) {
        this.x = x;
        this.y = y;
    }

    public PointElement(PointElement P) {
        this.x = new FieldElement(P.x);
        this.y = new FieldElement(P.y);
    }

    public PointElement(byte[] serialization, Field F) {
        int len = (F.degree() + 7) / 8;
        if (serialization.length == 1) {
            if (serialization[0] != 0) {
                throw new IllegalArgumentException("Bad serialization");
            }
            this.x = FieldElement.Zero(F);
            this.y = FieldElement.Zero(F);
        } else {
            if (serialization.length == len + 1) {
                throw new IllegalArgumentException("Point compression not supported");
            }
            if (serialization.length == 2 * len + 1) {
                if (serialization[0] != 4) {
                    throw new IllegalArgumentException("Bad serialization");
                }
                byte[] X = new byte[len];
                System.arraycopy(serialization, 1, X, 0, len);
                this.x = new FieldElement(X, F);
                byte[] Y = new byte[len];
                System.arraycopy(serialization, 1 + len, Y, 0, len);
                this.y = new FieldElement(Y, F);
            } else {
                throw new IllegalArgumentException("Bad serialization");
            }
        }
    }

    public byte[] toByteArray(Field f) {
        int len = 2 * ((f.degree() + 7) / 8) + 1;
        byte[] bytes = new byte[len];
        bytes[0] = 4;
        byte[] xs = this.x.toByteArray();
        for (int i = 0; i < xs.length; ++i) {
            bytes[1 + i] = xs[i];
        }
        byte[] ys = this.y.toByteArray();
        for (int i = 0; i < ys.length; ++i) {
            bytes[1 + xs.length + i] = ys[i];
        }
        return bytes;
    }

    public boolean isInfinity() {
        return this.x.isZero() && this.y.isZero();
    }

    public boolean equals(PointElement P) {
        return this.x.equals(P.x) && this.y.equals(P.y);
    }

    public static PointElement Infinity(Field F) {
        return new PointElement(FieldElement.Zero(F), FieldElement.Zero(F));
    }

    public boolean isOnCurve(Curve C) {
        FieldElement left = FieldElement.add(FieldElement.square(this.y), FieldElement.multiply(this.x, this.y));
        FieldElement x2 = FieldElement.square(this.x);
        FieldElement right = FieldElement.multiply(this.x, x2);
        right.add(FieldElement.multiply(C.a, x2));
        right.add(C.b);
        return left.equals(right);
    }

    public String toString() {
        return this.x.toString() + ',' + this.y.toString();
    }
}

