/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gf2;

import com.cryptomathic.ecc.gf2.Curve;
import com.cryptomathic.ecc.gf2.FieldElement;
import com.cryptomathic.ecc.gf2.MontgomeryPointPair;
import com.cryptomathic.ecc.gf2.PointElement;
import com.cryptomathic.util.ByteArray;
import java.math.BigInteger;

public class Point
extends com.cryptomathic.ecc.Point {
    public Curve C;
    public PointElement P;

    public Point(byte[] serialization, Curve C) {
        this.P = new PointElement(serialization, C.F);
        this.C = C;
    }

    public Point(FieldElement x, FieldElement y, Curve C) {
        this.P = new PointElement(x, y);
        this.C = C;
    }

    public Point(PointElement P, Curve C) {
        this.P = P;
        this.C = C;
    }

    public Point(Point P) {
        this.P = P.P;
        this.C = P.C;
    }

    public Point(String x, String y, Curve C) {
        this(new FieldElement(ByteArray.toByteArray(x), C.F), new FieldElement(ByteArray.toByteArray(y), C.F), C);
    }

    public PointElement getPointElement() {
        return this.P;
    }

    public static Point Infinity(Curve C) {
        return new Point(FieldElement.Zero(C.F), FieldElement.Zero(C.F), C);
    }

    public static Point scalarMultiply(PointElement P, BigInteger a, Curve C) {
        return Point.scalarMultiply(new Point(P, C), a);
    }

    public static Point scalarMultiply(Point P, BigInteger a) {
        MontgomeryPointPair m = new MontgomeryPointPair(P);
        for (int i = a.bitLength() - 2; i >= 0; --i) {
            if (a.testBit(i)) {
                m.mP1.add(m.mP2, P);
                m.mP2.doubl();
                continue;
            }
            m.mP2.add(m.mP1, P);
            m.mP1.doubl();
        }
        return m.toPoint();
    }

    public boolean isOnCurve() {
        return this.P.isOnCurve(this.C);
    }

    public static FieldElement addXCoords(Point P, Point Q) {
        if (P.isInfinity()) {
            return new FieldElement(Q.getx());
        }
        if (Q.isInfinity()) {
            return new FieldElement(P.getx());
        }
        if (P.getx().equals(Q.getx())) {
            if (P.getx().isZero() || !P.gety().equals(Q.gety())) {
                return FieldElement.Zero(P.C.F);
            }
            FieldElement T1 = FieldElement.inverse(P.getx());
            T1.multiply(P.gety());
            T1.add(P.getx());
            FieldElement T2 = FieldElement.add(P.C.a, T1);
            T1.square();
            T2.add(T1);
            return T2;
        }
        FieldElement T1 = FieldElement.add(P.getx(), Q.getx());
        FieldElement T2 = FieldElement.add(P.gety(), Q.gety());
        T2.multiply(FieldElement.inverse(T1));
        T1.add(T2);
        T2.square();
        T1.add(T2);
        T1.add(P.C.a);
        return T1;
    }

    public static Point add(Point P, Point Q) {
        FieldElement x3;
        FieldElement l;
        if (P.isInfinity()) {
            return new Point(Q);
        }
        if (Q.isInfinity()) {
            return new Point(P);
        }
        if (!P.getx().equals(Q.getx())) {
            l = FieldElement.inverse(FieldElement.add(P.getx(), Q.getx()));
            l = FieldElement.multiply(l, FieldElement.add(P.gety(), Q.gety()));
            x3 = FieldElement.square(l);
            x3.add(l);
            x3.add(P.getx());
            x3.add(Q.getx());
            x3.add(P.C.a);
        } else {
            if (!P.gety().equals(Q.gety())) {
                return Point.Infinity(P.C);
            }
            if (P.getx().isZero()) {
                return Point.Infinity(P.C);
            }
            l = FieldElement.add(P.getx(), FieldElement.multiply(P.gety(), FieldElement.inverse(P.getx())));
            x3 = FieldElement.square(l);
            x3.add(l);
            x3.add(P.C.a);
        }
        FieldElement y3 = FieldElement.add(Q.getx(), x3);
        y3.multiply(l);
        y3.add(x3);
        y3.add(Q.gety());
        return new Point(x3, y3, P.C);
    }

    public com.cryptomathic.ecc.Point scalarMultiply(BigInteger a) {
        return Point.scalarMultiply(this, a);
    }

    public FieldElement gety() {
        return this.P.y;
    }

    public FieldElement getx() {
        return this.P.x;
    }

    public BigInteger xtoBigInteger() {
        return this.P.x.toBigInteger();
    }

    public BigInteger addXCoordstoBigInteger(com.cryptomathic.ecc.Point T) {
        return Point.addXCoords(this, (Point)T).toBigInteger();
    }

    public com.cryptomathic.ecc.Curve getCurve() {
        return this.C;
    }

    public boolean isInfinity() {
        return this.P.isInfinity();
    }

    public boolean equals(com.cryptomathic.ecc.Point Q) {
        return this.P.equals(((Point)Q).P);
    }

    public String toString() {
        return this.getx().toString() + "," + this.gety().toString();
    }

    public byte[] xToByteArray() {
        return this.P.x.toByteArray();
    }

    public byte[] toByteArray() {
        return this.P.toByteArray(this.C.F);
    }
}

