/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gf2;

import com.cryptomathic.ecc.gf2.Curve;
import com.cryptomathic.ecc.gf2.FieldElement;
import com.cryptomathic.ecc.gf2.MontgomeryPoint;
import com.cryptomathic.ecc.gf2.Point;

class MontgomeryPointPair {
    Point P;
    MontgomeryPoint mP1 = new MontgomeryPoint();
    MontgomeryPoint mP2 = new MontgomeryPoint();
    Curve C;

    public MontgomeryPointPair(Point P) {
        this.mP1.x = new FieldElement(P.getx());
        this.mP1.z = FieldElement.One(P.C.F);
        this.mP2.z = FieldElement.square(P.getx());
        this.mP2.x = FieldElement.square(this.mP2.z);
        this.mP2.x.add(P.C.b);
        this.mP1.C = P.C;
        this.mP2.C = P.C;
        this.P = P;
    }

    public Point toPoint() {
        if (this.mP1.z.isZero()) {
            return Point.Infinity(this.P.C);
        }
        if (this.mP2.z.isZero()) {
            return new Point(new FieldElement(this.P.getx()), FieldElement.add(this.P.getx(), this.P.gety()), this.P.C);
        }
        FieldElement X1 = this.mP1.x;
        FieldElement Z1 = this.mP1.z;
        FieldElement X2 = this.mP2.x;
        FieldElement Z2 = this.mP2.z;
        FieldElement T1 = new FieldElement(this.P.getx());
        FieldElement T2 = new FieldElement(this.P.gety());
        FieldElement T3 = FieldElement.multiply(Z1, Z2);
        Z1.multiply(T1);
        Z1.add(X1);
        Z2.multiply(T1);
        X1.multiply(Z2);
        Z2.add(X2);
        Z2.multiply(Z1);
        FieldElement T4 = FieldElement.square(T1);
        T4.add(T2);
        T4.multiply(T3);
        T4.add(Z2);
        T3.multiply(T1);
        T3.inverse();
        T4.multiply(T3);
        X2 = FieldElement.multiply(X1, T3);
        Z2.assign(X2);
        Z2.add(T1);
        Z2.multiply(T4);
        Z2.add(T2);
        return new Point(X2, Z2, this.P.C);
    }
}

