/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.gf2;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ecc.ASN1.CharacteristicTwo;
import com.cryptomathic.ecc.ASN1.Pentanomial;
import com.cryptomathic.ecc.gf2.FieldElement;
import com.cryptomathic.ecc.gf2.Polynomial;
import java.util.Random;

public class Field
extends com.cryptomathic.ecc.Field {
    private int deg;
    private Polynomial r;
    private Polynomial[] u;
    public Polynomial f;
    private int[] coeffs;

    public Field(int deg, Polynomial r) {
        this.deg = deg;
        this.r = r;
        this.f = new Polynomial(deg);
        this.f.assign(r);
        this.coeffs = r.coefficients();
        this.f.set(deg);
        this.u = new Polynomial[64];
        for (int i = 0; i < 64; ++i) {
            this.u[i] = new Polynomial(r.maxDegree() + i);
            this.u[i].assign(r);
            this.u[i].shl(i);
        }
    }

    private static int[] asn1ToIntArray(CharacteristicTwo field) throws ASN1Exception {
        if (field.parameters.value instanceof ASN1Integer) {
            int[] bits = new int[]{((ASN1Integer)field.parameters.value).getInteger(), 0};
            return bits;
        }
        if (field.parameters.value instanceof Pentanomial) {
            int[] bits = new int[]{((Pentanomial)field.parameters.value).k3.getInteger(), ((Pentanomial)field.parameters.value).k2.getInteger(), ((Pentanomial)field.parameters.value).k1.getInteger(), 0};
            return bits;
        }
        return null;
    }

    public Field(CharacteristicTwo field) throws ASN1Exception {
        this(field.m.getInteger(), Field.asn1ToIntArray(field));
    }

    private static final Polynomial makeR(int[] coefs) {
        Polynomial r = new Polynomial(coefs[0]);
        for (int i = 0; i < coefs.length; ++i) {
            r.set(coefs[i]);
        }
        return r;
    }

    private static final Polynomial makeR(int coef1, int coef2, int coef3, int coef4) {
        int[] coefs = new int[]{coef1, coef2, coef3, coef4};
        return Field.makeR(coefs);
    }

    private static final Polynomial makeR(int coef1, int coef2, int coef3) {
        int[] coefs = new int[]{coef1, coef2, coef3};
        return Field.makeR(coefs);
    }

    private static final Polynomial makeR(int coef1, int coef2) {
        int[] coefs = new int[]{coef1, coef2};
        return Field.makeR(coefs);
    }

    private static final Polynomial makeR(int coef1) {
        int[] coefs = new int[]{coef1};
        return Field.makeR(coefs);
    }

    public Field(int deg, int[] coefs) {
        this(deg, Field.makeR(coefs));
    }

    public Field(int deg, int coef1, int coef2, int coef3, int coef4) {
        this(deg, Field.makeR(coef1, coef2, coef3, coef4));
    }

    public Field(int deg, int coef1, int coef2, int coef3) {
        this(deg, Field.makeR(coef1, coef2, coef3));
    }

    public Field(int deg, int coef1, int coef2) {
        this(deg, Field.makeR(coef1, coef2));
    }

    public Field(int deg, int coef1) {
        this(deg, Field.makeR(coef1));
    }

    public boolean equals(Field f) {
        return this.r.equals(f.r) && this.deg == f.deg;
    }

    public void reduce(Polynomial c) {
        int m = this.deg;
        if (c.degree() > 2 * m - 2) {
            throw new IllegalArgumentException("Degree too high (" + c.degree() + ">" + (2 * m - 2) + ")");
        }
        Polynomial c1 = new Polynomial(c);
        Polynomial c0 = new Polynomial(c);
        c1.shr(m);
        c0.truncate(m - 1);
        if (this.coeffs.length == 2) {
            c0.add(c1);
            c1.shl(this.coeffs[1]);
            c0.add(c1);
        } else {
            c0.add(c1);
            c1.shl(this.coeffs[1]);
            c0.add(c1);
            c1.shl(this.coeffs[2] - this.coeffs[1]);
            c0.add(c1);
            c1.shl(this.coeffs[3] - this.coeffs[2]);
            c0.add(c1);
        }
        c1.assign(c0);
        c1.shr(m);
        c0.truncate(m - 1);
        if (this.coeffs.length == 2) {
            c0.add(c1);
            c1.shl(this.coeffs[1]);
            c0.add(c1);
        } else {
            c0.add(c1);
            c1.shl(this.coeffs[1]);
            c0.add(c1);
            c1.shl(this.coeffs[2] - this.coeffs[1]);
            c0.add(c1);
            c1.shl(this.coeffs[3] - this.coeffs[2]);
            c0.add(c1);
        }
        c.assign(c0);
        c.truncate(m - 1);
    }

    public String toString() {
        return "F_2^" + this.deg + " = F_2[X]/(x^" + this.deg + "+" + this.r.toString_pol() + ")";
    }

    public int degree() {
        return this.deg;
    }

    public FieldElement generateRandom(Random rnd) {
        return new FieldElement(Polynomial.RandomPolynomial(this.deg - 1, rnd), this);
    }

    public int getFieldSize() {
        return this.deg;
    }
}

