/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.ecc.ASN1.ECParameters;
import com.cryptomathic.ecc.gfp.Curve;
import java.math.BigInteger;

public abstract class Point {
    public abstract Point scalarMultiply(BigInteger var1);

    public abstract boolean isOnCurve();

    public abstract com.cryptomathic.ecc.Curve getCurve();

    public abstract boolean equals(Point var1);

    public abstract boolean isInfinity();

    public abstract BigInteger xtoBigInteger();

    public abstract byte[] xToByteArray();

    public abstract BigInteger addXCoordstoBigInteger(Point var1);

    public static Point scalarMultiply(Point P, BigInteger a) {
        return P.scalarMultiply(a);
    }

    public abstract byte[] toByteArray();

    public static Point decode(byte[] publicKey, ECParameters parameter) throws ASN1Exception {
        if (parameter.fieldID.fieldType.equals(new ObjectIdentifier(OIDs.characteristic_two_field))) {
            com.cryptomathic.ecc.gf2.Curve C = new com.cryptomathic.ecc.gf2.Curve(parameter);
            com.cryptomathic.ecc.gf2.Point point = new com.cryptomathic.ecc.gf2.Point(publicKey, C);
            return point;
        }
        if (parameter.fieldID.fieldType.equals(new ObjectIdentifier(OIDs.prime_field))) {
            Curve C = new Curve(parameter);
            com.cryptomathic.ecc.gfp.Point point = new com.cryptomathic.ecc.gfp.Point(publicKey, C);
            return point;
        }
        throw new ASN1Exception("Illegal fieldType");
    }
}

