/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ecc.ASN1.ECParameters;
import com.cryptomathic.ecc.ASN1.SubjectPublicKeyInfo;
import com.cryptomathic.ecc.Curve;
import com.cryptomathic.ecc.ECDSA;
import com.cryptomathic.ecc.ECDSASignature;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Random;

public class ECPrivateKey
implements PrivateKey {
    Curve C;
    BigInteger S;

    public ECPrivateKey(Curve C, BigInteger d) {
        this.C = C;
        this.S = d;
    }

    public void init(com.cryptomathic.ecc.ASN1.ECPrivateKey privateKey) throws ASN1Exception {
        Curve C2;
        Curve C1;
        if (privateKey.parameters == null && privateKey.publicKey == null) {
            throw new ASN1Exception("Domain parameters are missing");
        }
        ECParameters parameters1 = null;
        ECParameters parameters2 = null;
        if (privateKey.parameters != null) {
            parameters1 = privateKey.parameters;
        }
        if (privateKey.publicKey != null) {
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo();
            spki.decode(privateKey.publicKey.getAsByteString());
            parameters2 = (ECParameters)spki.algorithm.parameters.value;
        }
        if (parameters1 != null && parameters2 != null && !(C1 = Curve.decode(parameters1)).equals(C2 = Curve.decode(parameters2))) {
            throw new ASN1Exception("Domain parameters does not match");
        }
        if (parameters1 == null) {
            parameters1 = parameters2;
        }
        this.C = Curve.decode(parameters1);
        this.S = new BigInteger(1, privateKey.privateKey.value).mod(this.C.getOrder());
    }

    public ECPrivateKey(byte[] encoding) throws ASN1Exception {
        com.cryptomathic.ecc.ASN1.ECPrivateKey privateKey = new com.cryptomathic.ecc.ASN1.ECPrivateKey();
        privateKey.decode(encoding);
        this.init(privateKey);
    }

    public byte[] getEncoded() {
        try {
            com.cryptomathic.ecc.ASN1.ECPrivateKey asn1 = new com.cryptomathic.ecc.ASN1.ECPrivateKey(this);
            return asn1.encode();
        }
        catch (ASN1Exception e) {
            return null;
        }
    }

    public String getAlgorithm() {
        return "EC";
    }

    public String getFormat() {
        return "ASN.1";
    }

    public BigInteger getS() {
        return this.S;
    }

    public ECDSASignature sign_ECDSA(byte[] hash, Random rnd) {
        return ECDSA.sign(this, hash, rnd);
    }

    public Curve getCurve() {
        return this.C;
    }
}

