/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.OIDs;
import com.cryptomathic.ASN1.ObjectIdentifier;
import com.cryptomathic.crypto.hash.FIPS_Derived_Random;
import com.cryptomathic.ecc.ASN1.ECParameters;
import com.cryptomathic.ecc.ECPrivateKey;
import com.cryptomathic.ecc.ECPublicKey;
import com.cryptomathic.ecc.Field;
import com.cryptomathic.ecc.Point;
import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Random;

public abstract class Curve {
    public abstract BigInteger getOrder();

    public abstract Point getG();

    public abstract Field getField();

    public KeyPair generateKeyPair(Random rnd) {
        BigInteger d = rnd instanceof FIPS_Derived_Random ? new BigInteger((this.getOrder().bitLength() + 159) / 160 * 160, rnd).mod(this.getOrder().subtract(BigInteger.ONE)).add(BigInteger.ONE) : new BigInteger(this.getOrder().bitLength() + 32, rnd).mod(this.getOrder());
        Point P = this.getG().scalarMultiply(d);
        ECPrivateKey priv = new ECPrivateKey(this, d);
        ECPublicKey pub = new ECPublicKey(P);
        return new KeyPair(pub, priv);
    }

    public abstract String toString();

    public Point generateRandomPoint(Random rnd) {
        BigInteger d = rnd instanceof FIPS_Derived_Random ? new BigInteger((this.getOrder().bitLength() + 159) / 160 * 160, rnd).mod(this.getOrder().subtract(BigInteger.ONE)).add(BigInteger.ONE) : new BigInteger(this.getOrder().bitLength() + 32, rnd).mod(this.getOrder());
        return this.getG().scalarMultiply(d);
    }

    public abstract boolean validate();

    protected static boolean MOVcondition(BigInteger q, BigInteger n) {
        BigInteger t = BigInteger.valueOf(1L);
        BigInteger one = BigInteger.valueOf(1L);
        int B = 20;
        for (int i = 1; i < B; ++i) {
            if (!(t = t.multiply(q).mod(n)).equals(one)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean equals(Object var1);

    public abstract byte[] getA();

    public abstract byte[] getB();

    public static Curve decode(ECParameters parameter) throws ASN1Exception {
        if (parameter.fieldID.fieldType.equals(new ObjectIdentifier(OIDs.characteristic_two_field))) {
            com.cryptomathic.ecc.gf2.Curve C = new com.cryptomathic.ecc.gf2.Curve(parameter);
            return C;
        }
        if (parameter.fieldID.fieldType.equals(new ObjectIdentifier(OIDs.prime_field))) {
            com.cryptomathic.ecc.gfp.Curve C = new com.cryptomathic.ecc.gfp.Curve(parameter);
            return C;
        }
        throw new ASN1Exception("Illegal fieldType");
    }

    public static Curve decode(byte[] encoding) throws ASN1Exception {
        ECParameters parameter = new ECParameters();
        parameter.decode(encoding);
        return Curve.decode(parameter);
    }
}

