/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.ecc.ASN1;

import com.cryptomathic.ASN1.ASN1Exception;
import com.cryptomathic.ASN1.ASN1Integer;
import com.cryptomathic.ASN1.ASN1Object;
import com.cryptomathic.ASN1.BitString;
import com.cryptomathic.ASN1.OctetString;
import com.cryptomathic.ASN1.Sequence;
import com.cryptomathic.ASN1.SequenceTemplate;
import com.cryptomathic.ecc.ASN1.Curve;
import com.cryptomathic.ecc.ASN1.ECParameters;
import com.cryptomathic.ecc.ECPublicKey;
import java.util.Vector;

public class ECPrivateKey
extends Sequence {
    public ASN1Integer version;
    public OctetString privateKey;
    public ECParameters parameters;
    public BitString publicKey;

    protected void setMembers(Vector v) throws ASN1Exception {
        this.version = (ASN1Integer)v.elementAt(0);
        this.privateKey = (OctetString)v.elementAt(1);
        this.parameters = (ECParameters)v.elementAt(2);
        this.publicKey = (BitString)v.elementAt(3);
    }

    protected Vector getMembers() {
        Vector<ASN1Object> v = new Vector<ASN1Object>(4);
        v.addElement(this.version);
        v.addElement(this.privateKey);
        v.addElement(this.parameters);
        v.addElement(this.publicKey);
        return v;
    }

    protected SequenceTemplate getTemplate() throws ASN1Exception {
        SequenceTemplate template = new SequenceTemplate();
        template.addMember(ASN1Integer.class);
        template.addMember(OctetString.class);
        template.addExplicitOptionalMember(ECParameters.class, 0);
        template.addExplicitOptionalMember(BitString.class, 1);
        return template;
    }

    private void initPrivateKey(com.cryptomathic.ecc.ECPrivateKey privateKey) {
        int fieldBitSize = privateKey.getCurve().getField().getFieldSize();
        byte[] encodedPrivateKey = privateKey.getS().toByteArray();
        byte[] os = new byte[fieldBitSize];
        int i = encodedPrivateKey.length - 1;
        for (int j = os.length - 1; i >= 0 && j >= 0; --i, --j) {
            os[j] = encodedPrivateKey[i];
        }
        this.privateKey = new OctetString(os);
    }

    private void initVersion() {
        this.version = new ASN1Integer(1);
    }

    private void initParameters(com.cryptomathic.ecc.Curve curve) throws ASN1Exception {
        this.parameters = new ECParameters(curve);
    }

    public void initPublicKey(ECPublicKey publicKey, Curve curve) {
    }

    public void initPublicKey(ECPublicKey publicKey) {
        this.publicKey = new BitString(publicKey.getEncoded(), 0);
    }

    public ECPrivateKey(com.cryptomathic.ecc.ECPrivateKey privateKey) throws ASN1Exception {
        this.initVersion();
        this.initPrivateKey(privateKey);
        this.initParameters(privateKey.getCurve());
    }

    public ECPrivateKey(com.cryptomathic.ecc.ECPrivateKey privateKey, ECPublicKey publicKey) {
        this.initVersion();
        this.initPrivateKey(privateKey);
        this.initPublicKey(publicKey);
    }

    public ECPrivateKey(com.cryptomathic.ecc.ECPrivateKey privateKey, com.cryptomathic.ecc.Curve curve, ECPublicKey publicKey) throws ASN1Exception {
        this.initVersion();
        this.initPrivateKey(privateKey);
        this.initParameters(curve);
        this.initPublicKey(publicKey);
    }

    public ECPrivateKey() {
    }
}

