/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.rsa;

import com.cryptomathic.crypto.rsa.EMessageTooLongException;
import com.cryptomathic.crypto.util.Memory;
import com.cryptomathic.crypto.util.UByteArray;
import com.cryptomathic.security.RSAPrivateKey;
import com.cryptomathic.security.RSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SignatureException;

public class Signature {
    private static final byte[] _permutation = new byte[]{14, 3, 5, 8, 9, 4, 2, 15, 0, 13, 11, 6, 7, 10, 12, 1};
    private static final byte[] _shadow = new byte[256];
    private static final byte[] _inverse_shadow = new byte[256];

    public static byte[] sign(RSAPrivateKey privateKey, byte[] message) throws InvalidKeyException, EMessageTooLongException {
        int r = 1;
        int ks = privateKey.getModulus().bitLength() - 1;
        if (message.length * 16 > ks + 3) {
            throw new EMessageTooLongException();
        }
        byte[] ir = null;
        ir = Signature.putRedundancy(message, ks, r);
        UByteArray.clearBits(ir, ks, ir.length * 8 - ks);
        ir[ir.length - 1] = (byte)(ir[ir.length - 1] << 4 | 6);
        UByteArray.setBit(ir, ks - 1);
        BigInteger sigma = null;
        try {
            sigma = UByteArray.toBigInteger(ir);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        sigma = privateKey.exp(sigma);
        BigInteger complement = privateKey.getModulus().subtract(sigma);
        sigma = sigma.min(complement);
        return UByteArray.toByteArray(sigma);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] verify(RSAPublicKey publicKey, byte[] signature) throws SignatureException {
        BigInteger sigma = null;
        BigInteger is = null;
        BigInteger complement = null;
        BigInteger six = BigInteger.valueOf(6L);
        BigInteger sixteen = BigInteger.valueOf(16L);
        BigInteger half_modulus = publicKey.getModulus().divide(BigInteger.valueOf(2L));
        byte[] ir = null;
        try {
            sigma = UByteArray.toBigInteger(signature);
            if (sigma.subtract(half_modulus).signum() != -1) {
                return null;
            }
            is = publicKey.exp(sigma);
        }
        catch (NumberFormatException ex) {
            throw new SignatureException();
        }
        if (!is.mod(sixteen).equals(six)) {
            complement = publicKey.getModulus().subtract(is);
            if (!complement.mod(sixteen).equals(six)) return null;
            ir = UByteArray.toByteArray(complement);
        } else {
            ir = UByteArray.toByteArray(is);
        }
        int ks = publicKey.getModulus().bitLength() - 1;
        int ks_bit_no = (ks - 1) % 8;
        if ((ir[UByteArray.getByteIndex(ir, ks - 1)] & 1 << ks_bit_no) != 1 << ks_bit_no) {
            return null;
        }
        if ((ir[ir.length - 1] & 0xF) == 6) return Signature.recoverMessage(ir, ks);
        return null;
    }

    public static boolean verify(RSAPublicKey publicKey, byte[] signature, byte[] message) throws SignatureException {
        byte[] recovered_message = null;
        recovered_message = Signature.verify(publicKey, signature);
        return Memory.byteCompare(recovered_message, message);
    }

    private static byte[] putRedundancy(byte[] message, int k_s, int r) {
        Integer minimum_bits = new Integer(k_s - 1);
        int t = new Double(Math.ceil(minimum_bits.doubleValue() / 16.0)).intValue();
        int t2 = 2 * t;
        int z = message.length;
        byte[] mr = new byte[2 * t];
        byte[] ir = null;
        for (int i = 0; i < t; ++i) {
            int j = z - 1 - i % z;
            mr[t2 - 1 - 2 * i] = message[j];
            int index = message[j] < 0 ? 256 + message[j] : message[j];
            mr[t2 - 1 - (2 * i + 1)] = _shadow[index];
        }
        int n = t2 - 1 - (2 * z - 1);
        mr[n] = (byte)(mr[n] ^ (byte)r);
        if ((k_s - 1) % 8 == 0) {
            ir = new byte[t2 + 1];
            System.arraycopy(mr, 0, ir, 1, mr.length);
            mr = ir;
        }
        return mr;
    }

    private static byte[] recoverMessage(byte[] message, int k_s) {
        Integer minimum_bits = new Integer(k_s - 1);
        int t = new Double(Math.ceil(minimum_bits.doubleValue() / 16.0)).intValue();
        int t2 = 2 * t;
        int z = -1;
        int r = -1;
        byte[] mr = new byte[t2];
        int index_start = UByteArray.getByteIndex(message, k_s - 1 - 1);
        int offset = message.length - mr.length;
        for (int i = message.length - 1; i >= index_start; --i) {
            mr[i - offset] = message[i];
        }
        byte lsb0 = mr[mr.length - 1];
        byte lsb1 = mr[mr.length - 2];
        byte mu2 = (byte)((lsb0 & 0xF0) >> 4);
        byte mu4 = (byte)((lsb1 & 0xF0) >> 4);
        int toBeCleared = (1 - k_s) % 16;
        if (toBeCleared < 0) {
            toBeCleared += 16;
        }
        int firstToBeCleared = mr.length * 8 - toBeCleared;
        UByteArray.clearBits(mr, firstToBeCleared, toBeCleared);
        mr[mr.length - 1] = (byte)((byte)(_inverse_shadow[mu4] << 4) | mu2);
        int sum = 0;
        int null_sums = 0;
        for (int i = 0; i < t; ++i) {
            int index_m2i = t2 - 2 - 2 * i;
            int index_m2i_1 = t2 - 2 - (2 * i - 1);
            int index_shadow = mr[index_m2i_1] < 0 ? 256 + mr[index_m2i_1] : mr[index_m2i_1];
            sum = mr[index_m2i];
            if ((sum = (byte)(sum ^ _shadow[index_shadow])) == 0) continue;
            ++null_sums;
            r = sum;
            z = i + 1;
            break;
        }
        if (null_sums != 1) {
            return null;
        }
        if (r < 1 || r > 8) {
            return null;
        }
        byte[] mp = new byte[z];
        for (int i = 0; i < z; ++i) {
            mp[z - 1 - i] = mr[mr.length - 1 - 2 * i];
        }
        return mp;
    }

    static {
        for (int i = 0; i < _permutation.length; ++i) {
            byte P_mu2 = (byte)(_permutation[i] << 4);
            for (int j = 0; j < _permutation.length; ++j) {
                Signature._shadow[i * 16 + j] = (byte)(P_mu2 | _permutation[j]);
            }
        }
        int index = 0;
        for (int i = 0; i < _inverse_shadow.length; ++i) {
            index = _shadow[i] < 0 ? 256 + _shadow[i] : _shadow[i];
            Signature._inverse_shadow[index] = (byte)i;
        }
    }
}

