/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomathic.crypto.rsa;

import com.cryptomathic.crypto.hash.HashMech;
import com.cryptomathic.crypto.hash.HashPadMode;
import com.cryptomathic.crypto.hash.HashType;
import com.cryptomathic.crypto.rsa.CorruptEncryptionBlockException;
import com.cryptomathic.crypto.rsa.ParameterOutOfBoundsException;
import com.cryptomathic.crypto.rsa.Pkcs1v1Pad;
import com.cryptomathic.crypto.rsa.UnknownBlocktypeException;
import com.cryptomathic.security.RSAPrivateKey;
import com.cryptomathic.security.RSAPublicKey;
import java.math.BigInteger;

public class Pkcs1v1 {
    private static byte[] _SHA = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static byte[] _SHA224 = new byte[]{48, 45, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 4, 5, 0, 4, 28};
    private static byte[] _SHA256 = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
    private static byte[] _SHA384 = new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
    private static byte[] _SHA512 = new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};
    private static byte[] _MD4 = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 8, -122, -9, 13, 2, 4, 5, 0, 4, 16};
    private static byte[] _MD5 = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};

    public static byte[] sign(RSAPrivateKey privateKey, byte[] message, String digest) {
        HashType hmode = HashType.MD5;
        byte[] DAI = _MD5;
        if (digest.equalsIgnoreCase("sha")) {
            hmode = HashType.SHA;
            DAI = _SHA;
        } else if (digest.equalsIgnoreCase("sha224")) {
            hmode = HashType.SHA224;
            DAI = _SHA224;
        } else if (digest.equalsIgnoreCase("sha256")) {
            hmode = HashType.SHA256;
            DAI = _SHA256;
        } else if (digest.equalsIgnoreCase("sha384")) {
            hmode = HashType.SHA384;
            DAI = _SHA384;
        } else if (digest.equalsIgnoreCase("sha512")) {
            hmode = HashType.SHA512;
            DAI = _SHA512;
        } else if (digest.equalsIgnoreCase("md4")) {
            hmode = HashType.MD4;
            DAI = _MD4;
        }
        byte[] MD = new byte[]{};
        try {
            MD = HashMech.hash_mes(hmode, HashPadMode.NOPAD, message, message.length);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] D = new byte[MD.length + DAI.length];
        System.arraycopy(DAI, 0, D, 0, DAI.length);
        System.arraycopy(MD, 0, D, DAI.length, MD.length);
        byte[] ED = new byte[]{};
        try {
            ED = Pkcs1v1Pad.Pad(privateKey.getModulus().bitLength() + 7 >>> 3, (byte)1, D);
        }
        catch (UnknownBlocktypeException e) {
            // empty catch block
        }
        BigInteger mInt = new BigInteger(ED);
        BigInteger cInt = privateKey.exp(mInt);
        byte[] res2comp = cInt.toByteArray();
        return Pkcs1v1.checkBAlength(res2comp, privateKey.getModulus().bitLength());
    }

    private static boolean Equal(byte[] b1, byte[] b2, int no) {
        for (int i = 0; i < no; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean verify(RSAPublicKey publickey, byte[] message, byte[] signature) {
        return Pkcs1v1.verify((java.security.interfaces.RSAPublicKey)publickey, message, signature);
    }

    public static boolean verify(java.security.interfaces.RSAPublicKey publickey, byte[] message, byte[] signature) {
        BigInteger cInt = new BigInteger(1, signature);
        BigInteger mInt = cInt.modPow(publickey.getPublicExponent(), publickey.getModulus());
        byte[] MD0 = mInt.toByteArray();
        byte[] MD1 = new byte[publickey.getModulus().bitLength() + 7 >>> 3];
        MD1[0] = 0;
        if (MD1.length < MD0.length) {
            return false;
        }
        System.arraycopy(MD0, 0, MD1, MD1.length - MD0.length, MD0.length);
        if (MD1[1] != 1) {
            return false;
        }
        byte[] MD = new byte[]{};
        try {
            MD = Pkcs1v1Pad.Unpad(MD1);
        }
        catch (UnknownBlocktypeException e) {
        }
        catch (CorruptEncryptionBlockException e) {
            return false;
        }
        HashType hmode = HashType.MD5;
        int offset = 18;
        if (Pkcs1v1.Equal(_SHA, MD, 15)) {
            hmode = HashType.SHA;
            offset = 15;
        } else if (Pkcs1v1.Equal(_SHA224, MD, 19)) {
            hmode = HashType.SHA224;
            offset = 19;
        } else if (Pkcs1v1.Equal(_SHA256, MD, 19)) {
            hmode = HashType.SHA256;
            offset = 19;
        } else if (Pkcs1v1.Equal(_SHA384, MD, 19)) {
            hmode = HashType.SHA384;
            offset = 19;
        } else if (Pkcs1v1.Equal(_SHA512, MD, 19)) {
            hmode = HashType.SHA512;
            offset = 19;
        } else if (Pkcs1v1.Equal(_MD4, MD, 18)) {
            hmode = HashType.MD4;
        } else if (Pkcs1v1.Equal(_MD5, MD, 18)) {
            offset = 18;
        } else {
            return false;
        }
        try {
            byte[] MD2 = HashMech.hash_mes(hmode, HashPadMode.NOPAD, message, message.length);
            if (MD.length - offset != MD2.length) {
                return false;
            }
            for (int i = 0; i < MD2.length; ++i) {
                if (MD[offset + i] == MD2[i]) continue;
                return false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    public static byte[] encrypt(RSAPublicKey publickey, byte[] message) {
        try {
            return Pkcs1v1.encrypt(publickey, (byte)2, message);
        }
        catch (ParameterOutOfBoundsException e) {
            return new byte[0];
        }
    }

    public static byte[] encrypt(RSAPublicKey publickey, byte blocktype, byte[] message) throws ParameterOutOfBoundsException {
        if (blocktype != 0 && blocktype != 2) {
            throw new ParameterOutOfBoundsException("Only blocktype 0x00 & 0x02 allowed");
        }
        byte[] EB = new byte[]{};
        try {
            EB = Pkcs1v1Pad.Pad(publickey.getModulus().bitLength() + 7 >>> 3, blocktype, message);
        }
        catch (UnknownBlocktypeException e) {
            // empty catch block
        }
        BigInteger cInt = publickey.exp(new BigInteger(1, EB));
        byte[] res2comp = cInt.toByteArray();
        return Pkcs1v1.checkBAlength(res2comp, publickey.getModulus().bitLength());
    }

    public static byte[] decrypt(RSAPrivateKey privatekey, byte[] message) throws UnknownBlocktypeException, CorruptEncryptionBlockException {
        BigInteger cInt = new BigInteger(1, message);
        BigInteger mInt = privatekey.exp(cInt);
        byte[] tmp = mInt.toByteArray();
        return Pkcs1v1Pad.Unpad(Pkcs1v1.checkBAlength(tmp, privatekey.getModulus().bitLength()));
    }

    public static byte[] decrypt(RSAPrivateKey privatekey, byte[] message, int outputLength) throws ParameterOutOfBoundsException, UnknownBlocktypeException, CorruptEncryptionBlockException {
        byte[] tmp = Pkcs1v1.decrypt(privatekey, message);
        if (tmp.length > outputLength) {
            throw new ParameterOutOfBoundsException("Requested size too small");
        }
        byte[] tmp2 = new byte[outputLength];
        System.arraycopy(tmp, 0, tmp2, outputLength - tmp.length, tmp.length);
        return tmp2;
    }

    private static byte[] checkBAlength(byte[] ba, int bitlength) {
        int bytelength = bitlength + 7 >>> 3;
        if (bytelength > ba.length) {
            byte[] temp = new byte[bytelength];
            System.arraycopy(ba, 0, temp, bytelength - ba.length, ba.length);
            return temp;
        }
        if (bytelength < ba.length) {
            byte[] temp = new byte[bytelength];
            System.arraycopy(ba, ba.length - bytelength, temp, 0, bytelength);
            return temp;
        }
        return ba;
    }
}

